* (3) PISA 2009

use "C:\Users\John\Pictures\STATA_VERSION_9\PISA_2009\PISA_2009.dta", clear
destring COUNTRY, gen(Country)
destring SUBNATIO, gen(Subnation)
destring STRATUM, gen (Stratum)
destring SCHOOLID, replace
encode TESTLANG, gen(Test_Lang)

replace Country= 827 if Country==826 & Subnation==82620

gen Wales=0
replace Wales=1 if Country==826 & (Stratum==82624|Stratum==82625|Stratum==82626)
replace Wales=1 if Country==826 & (SCHOOLID==70)
replace Wales=1 if Country==826 & (SCHOOLID==114)
replace Wales=1 if Country==826 & (SCHOOLID==154)
replace Wales=1 if Country==826 & (SCHOOLID==155)
replace Wales=1 if Country==826 & (SCHOOLID==179)
replace Wales=1 if Country==826 & (SCHOOLID==235)
replace Wales=1 if Country==826 & (SCHOOLID==249)
replace Wales=1 if Country==826 & (SCHOOLID==261)
replace Wales=1 if Country==826 & (SCHOOLID==278)
replace Wales=1 if Country==826 & (SCHOOLID==286)
replace Wales=1 if Country==826 & (SCHOOLID==306)
replace Wales=1 if Country==826 & (SCHOOLID==316)
replace Wales=1 if Country==826 & (SCHOOLID==329)
replace Wales=1 if Country==826 & (SCHOOLID==337)
replace Wales=1 if Country==826 & (SCHOOLID==342)
replace Wales=1 if Country==826 & (SCHOOLID==363)
replace Wales=1 if Country==826 & (SCHOOLID==402)
replace Wales=1 if Country==826 & (SCHOOLID==445)
replace Wales=1 if Country==826 & (SCHOOLID==456)
replace Wales=1 if Country==826 & (SCHOOLID==476)

tab Wales


rename PV1READ ReadScore1
rename PV2READ ReadScore2
rename PV3READ ReadScore3
rename PV4READ ReadScore4
rename PV5READ ReadScore5
rename PV1MATH MathScore1
rename PV2MATH MathScore2
rename PV3MATH MathScore3
rename PV4MATH MathScore4
rename PV5MATH MathScore5
rename PV1SCIE SciScore1
rename PV2SCIE SciScore2
rename PV3SCIE SciScore3
rename PV4SCIE SciScore4
rename PV5SCIE SciScore5
rename ST04Q01 Gender
rename ST17Q01 StudentCountryBorn
rename ST17Q02 MotherCountryBorn
rename ST17Q03 FatherCountryBorn
gen StudentImmgrant=0 
replace StudentImmgrant=1 if StudentCountryBorn==2
gen FatherImmgrant=0 
replace FatherImmgrant=1 if FatherCountryBorn==2
gen MotherImmgrant=0 
replace MotherImmgrant=1 if MotherCountryBorn==2
gen Immigrant=0  
replace Immigrant=1 if (StudentImmgrant==1|MotherImmgrant==1|FatherImmgrant==1)

rename AGE Age

rename  BMMJ Mother_Occ
replace  Mother_Occ=. if Mother_Occ>94

rename  BFMJ Father_Occ
replace  Father_Occ=. if Father_Occ>94

gen Average_Occ = ((Mother_Occ  +  Father_Occ) / 2 ) if Mother_Occ!=. & Father_Occ!=.
replace Average_Occ = Father_Occ if Average_Occ==. & Father_Occ!=.
replace Average_Occ = Mother_Occ if Average_Occ==. & Mother_Occ!=.

rename HISEI Highest_Occ

gen Hi_Ed = 0 if  HISCED<3
replace Hi_Ed = 1 if  HISCED>2 & HISCED<5
replace Hi_Ed = 2 if  (HISCED==5|HISCED==6)
tab HISCED Hi_Ed 

replace Highest_Occ=. if Highest_Occ>94
xtile Highest_Occ_Quart_Alt=Highest_Occ [pweight = W_FSTUWT] if Highest_Occ!=., nq(5)
tab Country Highest_Occ_Quart_Alt

replace ST22Q01=. if ST22Q01>6
replace HISCED=. if HISCED>6
replace FISCED=. if FISCED>6
replace MISCED=. if MISCED>6
replace WEALTH=. if WEALTH>10
replace CULTPOSS=. if CULTPOSS>10

corr ST22Q01  FISCED  [aw = W_FSTUWT] 
corr ST22Q01  MISCED  [aw = W_FSTUWT] 
corr ST22Q01  WEALTH  [aw = W_FSTUWT] 
corr ST22Q01  CULTPOSS  [aw = W_FSTUWT] 
corr ST22Q01  Highest_Occ  [aw = W_FSTUWT] 



spearman ST22Q01  FISCED   
spearman ST22Q01  MISCED   
spearman ST22Q01  WEALTH  




keep StIDStd Country COUNTRY Age SCHOOLID Stratum W_FSTUWT ESCS Gender Immigrant ReadScore1-ReadScore5 MathScore1-MathScore5  SciScore1-SciScore5 Highest_Occ Average_Occ /*
*/ Highest_Occ_Quart_Alt Hi_Ed Wales
save "C:\Users\John\Favorites\STATA_VERSION_9\PISA_2009\PISA_2009_For_Quant_Reg.dta", replace




