*JJ created 11/01/13
*JJ Updated 11/01/13

*STEP 1 - merge together the data
use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Fourth_Grade_TIMSS_2003\TIMSS_2003_For_Changes.dta" , clear
append using "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_2007_For_Changes.dta"
set seed 984744																							/***Set random number seed in order to replicate results ***/

*STEP 2 - Set up complex survey design
svyset School_ID [pw = Weight]

global countries 36 158 344 380 392 440 578 643 702 705 840 926 927												/*** Create a global macro for each of the  countries ***/

*STEP 3 - Do analysis of mean changes over time
foreach i of global countries {
									xi:svy:regress Z_Math_Score i.Year if Country==`i'								/*** Change between the two surveys ***/										
									}																				/*** Equivalent to a two-sample t-test ***/


									
*STEP 4 - Do analysis of how P10 chanes over time
*																										/*** CORRESPONDS TO RIGHT-HAND COLUMN OF TABLE 4B ***/				
capture program drop q10
program q10
			xi:qreg Z_Math_Score i.Year [aweight= Weight] if Country==`1' , q(0.10)						/***Year coefficient provides the change over time***/
end
foreach i of global countries {								
									bs, cluster(School_ID): q10 `i'										/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}


*STEP 5 - Do analysis of how P90 chanes over time
*																										/*** CORRESPONDS TO RIGHT-HAND COLUMN OF TABLE 4B ***/				
capture program drop q90
program q90
			xi:qreg Z_Math_Score i.Year [aweight= Weight] if Country==`1' , q(0.90)						/***Year coefficient provides the change over time***/
end
foreach i of global countries {								
									bs, cluster(School_ID): q90 `i'										/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}


*STEP 6 - Do analysis of whether change in P10 significantly different to England
replace Country=0 if Country==926																	/***Set England to baseline group ***/
*																												
capture program drop q10_country
program q10_country																					/*** The Year*Country coefficients should show whether change over time in a given country is significantly different ***/
	xi:qreg Z_Math_Score i.Year*i.Country [aweight= Weight] , q(0.10)								/*** to the change in England ***/							
end
foreach i of global countries {								
									bs, cluster(School_ID): q10_country 							/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}




*STEP 7 - Do analysis of whether change in P90 significantly different to England
replace Country=0 if Country==926																	/***Set England to baseline group ***/
capture program drop q90_country
program q90_country																					/*** The Year*Country coefficients should show whether change over time in a given country is significantly different ***/
	xi:qreg Z_Math_Score i.Year*i.Country [aweight= Weight] , q(0.90)								/*** to the change in England ***/							
end
foreach i of global countries {								
									bs, cluster(School_ID): q90_country 										/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}


