***** JJ Last updated 15 / 12 / 12

*************************
***** (1) TIMSS 2007*****
*************************
local countries Aus Eng HK Ita Jap Ltu Nor Rus Sco Sgp Svn Twn USA										/**** Local for the countries - used below ***/

foreach i of local countries {																			/**** Loop the below for each of the countries ***/
					use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_`i'_2007.dta", clear	/**** Open TIMSS 2007 data for each given country ***/		
					gen Year = 2007																		/**** Create a new variable for the year ***/

					rename  idcntry  Country_ID															/**** Rename variables ***/
					rename  idschool  School_ID
					rename  idclass  Class_ID
					rename  idgrade  Grade
					rename  idstud   Pupil_ID
					rename  itbirthm Month_Birth
					rename  itbirthy  Year_Birth
					rename  bs4gsex   Gender
					rename  bs4golan  Lang
					
					gen Books = 1 if (bs4gbook==1|bs4gbook==2)											/**** Create a new Books variable ***/
					replace Books =2 if (bs4gbook==3) 													/**** Base category as 0 - 25 books ***/
					replace Books =3 if (bs4gbook==4) 
					replace Books =4 if (bs4gbook==5)
					replace Books =100 if (bs4gbook>6) 
					label define Books  1 "0 - 25"  2 "26 - 100"  3 "101 - 200"  4 "200+"
					label values Books Books

					gen Immigrant = 0 if bs4gborn==1 & bs4gmbrn==1 & bs4gfbrn==1
					replace Immigrant = 1 if (bs4gborn==2|bs4gmbrn==2|bs4gfbrn==2)
					replace Immigrant = 100 if bs4gborn>2

					rename  bs4gth01  Calculator
					rename  bs4gth02  Computer
					rename  bs4gth03  Desk
					rename  bs4gth04  Dictonary
					rename  bs4gth05  Internet
					rename  bs4gth06  Wealth1
					rename  bs4gth07  Wealth2
					rename  bs4gth08  Wealth3	
					rename  bs4gth09  Wealth4
					rename   totwgt  Weight
					rename   bsmmat01 Math_Score1 
					rename    bsssci01 Sci_Score1 
					rename    bsdgpbss Index_Safe_School
					rename   bsdmscm Index_Conf_Math
					rename     bsdsscs Index_Conf_Sci
					rename    bsdmtmh Index_HW_Math
					rename    bsdstsh Index_HW_Sci
					rename   bs4gmbrn  Ma_Born_Country
					rename  bs4gfbrn Pa_Born_Country 
					rename  bs4gborn Self_Born_Country 

					keep  Country_ID  School_ID  Class_ID  Grade  Pupil_ID  Month_Birth  Year_Birth  Gender  Lang  Books  Calculator  Computer  /*
					*/  Desk  Dictonary  Internet  Wealth1  Wealth2  Wealth3  Wealth4  Weight Math_Score1  Sci_Score1 Index_Safe_School  Index_Conf_Math  /*
					*/   Index_Conf_Sci  Index_HW_Math  Index_HW_Sci  Ma_Born_Country Pa_Born_Country  Self_Born_Country Year Immigrant
					save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_`i'_2007_Reduced_Alt.dta", replace
					}

clear


use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_Aus_2007_Reduced_Alt.dta", clear
foreach i of local countries {
					append using "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_`i'_2007_Reduced_Alt.dta"
					} 
duplicates drop
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_2007_MERGED_Alt.dta" , replace





*************************
*****TIMSS 2003**********
*************************
local countries Aus Eng HK Ita Jap Ltu Nor Rus Sco Sgp Svn Twn USA


foreach i of local countries {
					use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Fourth_Grade_TIMSS_2003\TIMSS_`i'_2003.dta", clear
					gen Year = 2003
					rename  idcntry  Country_ID
					rename  idschool  School_ID
					rename  idclass  Class_ID
					rename  idgrade  Grade
					rename  idstud   Pupil_ID
					rename  itbirthm Month_Birth
					rename  itdatey  Year_Birth
					rename  asbgsex    Gender
					rename  asbgolan  Lang

					gen Books = 1 if (asbgbook==1|asbgbook==2)
					replace Books =2 if (asbgbook==3) 
					replace Books =3 if (asbgbook==4) 
					replace Books =4 if (asbgbook==5)
					replace Books =100 if (asbgbook>6) 
					label define Books  1 "0 - 25"  2 "26 - 100"  3 "101 - 200"  4 "200+"
					label values Books Books

					gen Immigrant = 0 if asbgborn==1 & asbgmbrn==1 & asbgfbrn==1
					replace Immigrant = 1 if (asbgborn==2|asbgmbrn==2|asbgfbrn==2)
					replace Immigrant = 100 if asbgborn>2

					rename  asbgps01  Calculator
					rename  asbgps02  Computer
					rename  asbgps03  Desk
					rename  asbgps04  Dictonary
					rename  asbgps05  Wealth1
					rename  asbgps06  Wealth2
					rename  asbgps07  Wealth3	
					rename  asbgps08  Wealth4
					rename   totwgt  Weight
					rename   asmmat01 Math_Score1 
					rename   asssci01 Sci_Score1 
					rename   asdgpss Index_Safe_School
					rename   asdmscl Index_Conf_Math
					rename   asdsscl Index_Conf_Sci
					rename   asdmhw Index_HW_Math
					rename   asdshw Index_HW_Sci
					rename   asbgmbrn   Ma_Born_Country
					rename  asbgfbrn  Pa_Born_Country 
					rename  asbgborn Self_Born_Country 

					keep  Country_ID  School_ID  Class_ID  Grade  Pupil_ID  Month_Birth  Year_Birth  Gender  Lang  Books  Calculator  Computer  /*
					*/  Desk  Dictonary  Wealth1  Wealth2  Wealth3  Wealth4  Weight Math_Score1  Sci_Score1 Index_Safe_School  Index_Conf_Math  /*
					*/   Index_Conf_Sci  Index_HW_Math  Index_HW_Sci  Ma_Born_Country Pa_Born_Country  Self_Born_Country Year Immigrant
					save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Fourth_Grade_TIMSS_2003\TIMSS_`i'_2003_Reduced_Alt.dta", replace
					}

clear

use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Fourth_Grade_TIMSS_2003\TIMSS_Aus_2003_Reduced_Alt.dta", clear
foreach i of local countries {
					append using "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Fourth_Grade_TIMSS_2003\TIMSS_`i'_2003_Reduced_Alt.dta"
					} 
duplicates drop
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Fourth_Grade_TIMSS_2003\TIMSS_2003_MERGED_Alt.dta" , replace





*************************
*****PISA 2009**********
*************************
use "C:\Users\John\Pictures\STATA_VERSION_9\PISA_Changes\PISA_2009\PISA_2009_With_Wales_ID.dta", clear
sort COUNTRY SCHOOLID STIDSTD
keep STIDSTD SCHOOLID COUNTRY Country Nation_Code
save "C:\Users\John\Pictures\STATA_VERSION_9\PISA_Changes\PISA_2009\PISA_2009_Nation_Code.dta", replace

use "C:\Users\John\Pictures\STATA_VERSION_9\PISA_2009\PISA_2009.dta", clear

rename ST01Q01 Grade

gen Gender = 1 if  ST04Q01==1
replace Gender = 2 if  ST04Q01==2
label define Gender 1 "Girl"  2 "Boy"
label values Gender Gender
tab Gender

gen Books = 1 if (ST22Q01==1|ST22Q01==2)
replace Books =2 if (ST22Q01==3) 
replace Books =3 if (ST22Q01==4) 
replace Books =4 if (ST22Q01==5 | ST22Q01==6)
replace Books =100 if (ST22Q01>6) 
label define Books  1 "0 - 25"  2 "26 - 100"  3 "101 - 200"  4 "200+"
label values Books Books

gen Immigrant = 0 if ST17Q01==1 & ST17Q02==1 & ST17Q03==1
replace Immigrant = 1 if (ST17Q01==2|ST17Q02==2|ST17Q03==2)
replace Immigrant = 100 if ST17Q01>2


keep CNT COUNTRY SCHOOLID StIDStd PV1READ PV1MATH PV1SCIE W_FSTUWT SUBNATIO STRATUM ST03Q02 ST03Q03 Gender Books Immigrant Grade
rename StIDStd STIDSTD
rename PV1READ ReadScore1
rename PV1MATH MathScore1
rename PV1SCIE SciScore1

rename  W_FSTUWT Weight
gen Year=2009

destring COUNTRY, gen(Country)
destring SUBNATIO, gen(Subnation)
destring STRATUM, gen (Stratum)
replace Country= 827 if Country==826 & Subnation==82620

sort COUNTRY SCHOOLID STIDSTD
merge  1:m COUNTRY SCHOOLID STIDSTD using "C:\Users\John\Pictures\STATA_VERSION_9\PISA_Changes\PISA_2009\PISA_2009_Nation_Code.dta"
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009.dta", replace


use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_NonOECD.dta", clear

gen Gender = 1 if   st04q01==1
replace Gender = 2 if   st04q01==2
label define Gender 1 "Boy"  2 "Girl"
label values Gender Gender
tab Gender

gen Books = 1 if (st22q01==1|st22q01==2)
replace Books =2 if (st22q01==3) 
replace Books =3 if (st22q01==4) 
replace Books =4 if (st22q01==5 | st22q01==6)
replace Books =100 if (st22q01>6) 
label define Books  1 "0 - 25"  2 "26 - 100"  3 "101 - 200"  4 "200+"
label values Books Books

gen Immigrant = 0 if st17q01==1 & st17q02==1 & st17q03==1
replace Immigrant = 1 if (st17q01==2|st17q02==2|st17q03==2)
replace Immigrant = 100 if st17q01>2

destring country , gen(Country)
destring subnatio, gen(Subnation)
rename StIDStd STIDSTD
rename pv1read ReadScore1
rename pv1math MathScore1
rename pv1scie SciScore1
rename schoolid SCHOOLID
rename  w_fstuwt Weight
rename cnt CNT
gen Year=2009

keep CNT Country SCHOOLID STIDSTD Gender Books Immigrant ReadScore1 MathScore1 SciScore1 Weight Subnation Year 
sort Country SCHOOLID STIDSTD
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_NonOECD_To_Merge.dta", replace

use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009.dta", clear
append using "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_NonOECD_To_Merge.dta"

keep if (Country==36|Country==158|Country==344|Country==380|Country==392|Country==440|Country==578|Country==643|Country==702|Country==705|Country==826|Country==827|Country==840) 

replace Country=926 if Country==826
replace Country=927 if Country==827

rename  Country  Country_ID
destring  SCHOOLID ,gen (School_ID)
rename   ST03Q02  Month_Birth
destring Month_Birth, replace
rename  ST03Q03  Year_Birth
destring Year_Birth , replace
rename   MathScore1 Math_Score1 
rename   SciScore1 Sci_Score1 

destring STIDSTD , gen (STIDSTD_New)

keep STIDSTD_New Country_ID  School_ID  Month_Birth  Year_Birth Gender Books Immigrant Math_Score1  Sci_Score1 Year Weight Nation_Code Grade
drop if Math_Score1==.
sort Country_ID STIDSTD 
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_Merged.dta", replace

use "C:\Users\John\Pictures\STATA_VERSION_9\PISA_2009\Country_Identifiers.dta" , clear
rename Country Country_ID
replace Country=926 if Country==826
replace Country=927 if Country==827
rename STIDSTD STIDSTD_New
sort Country_ID STIDSTD_New 
save "C:\Users\John\Pictures\STATA_VERSION_9\PISA_2009\Country_ID_Asia_Paper.dta" , replace

use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_Merged.dta", clear
capture drop _merge
merge Country_ID STIDSTD_New  using "C:\Users\John\Pictures\STATA_VERSION_9\PISA_2009\Country_ID_Asia_Paper.dta"
encode nation, generate(Nation)
tab Country Nation
drop if Nation==2
drop if Nation==4
drop if Grade==12 & Country==927
tab Country Nation
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_Merged.dta", replace



** MERGE TIMSS 2003 and 2007  and PISA 2009
use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Fourth_Grade_TIMSS_2003\TIMSS_2003_MERGED_Alt.dta" , clear
append using "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_2007_MERGED_Alt.dta"
append using "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_Merged.dta"
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_FINAL.dta" , replace



