****************
** JJ created 10/01/13
** JJ updated 10/01/13
***************

*STEP 1 - CHECK NOTHING HAS GONE WRONG WITH MERGING / RE-CODING
use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_Merged.dta", clear  		/*** Open the merged PISA 2009 data ***/
set seed 984744	

replace Math_Score1 =. if Nation_Code==1 
replace Math_Score1 =. if Nation_Code==3 


tab Country

label define Country 36 "Aus" 158 "Twn" 344 "Hkg" 348 "Hun" 360 "Ind" 380 "Ita" 392 "Jap" 440 "Ltu" /*		/*** Label countries ***/
*/ 578 "Nor" 643 "Rus" 702 "Sgp" 705 "Svn" 840 "USA" 926 "Eng" 927 "Sco", modify
label values Country Country


global countries_pisa 36 158 344 380 392 440 578 643 702 705 840 926 927												/*** Create a global macro for each of the  countries ***/

tab Country

foreach i of global countries_pisa {
									sum Math_Score1 [aw = Weight] if Country==`i' , d									/*** Distribution of math test scores (PISA metric) for each of the countries ***/										
									}																					/*** NOTE - aweights give same mean value as pweights ***/

***Note mean scores should be as follows (see page XX of XXX)
* AUS = 514 , TWN = 543 , HKG = 555  , Hun = XXX , ITA = 483 , JAP = 529  , LTU = 477 ,
* NOR = 498 , RUS = 468 , SGP = 562 , SVN = 501 , USA = 487 , ENG =   , SCO =  

***NOTE P75 should be as follows (see page XXX of XXX) 																	/*** NOTE - Figures one or two points different. As expected - I am using just one PV whereas the survey document uses all 5 PV's ***/
* AUS = 580 , TWN = 618 , HKG = 622 , Hun = XX , ITA = 548  , JAP = 595  , LTU = 537  ,									/*** Little substantive importance ***/
* NOR = 557 , RUS = 524 , SGP = 638 , SVN = 569 , USA = 551 , ENG =   , SCO =




*STEP 2 - STANDARDISE ACROSS COUNTRIES

sum Math_Score1 [aw = Weight]											/*** Get distribution of maths test scores across pupils in all countries being considerred ***/
gen Mean_Math_Score1 = r(mean)											/*** Create new variable reflecting the cross-country mean score ***/
gen SD_Math_Score1 = r(sd)												/*** Create new variable reflecting the cross-country standard deviation ***/
tab Mean_Math_Score1
tab SD_Math_Score1

gen Z_Math_Score =  (Math_Score1 - Mean_Math_Score1) / SD_Math_Score1		/*** Create standardised score by subtracting cross -country mean and dividing by SD ***/
sum Z_Math_Score [aw = Weight], d											/*** Check distribution ***/



*STEP 3 - RESULTS FOR PISA 2009

foreach i of global countries_pisa {
									sum Z_Math_Score [aw = Weight] if Country==`i' , d									/*** Distribution of math test scores (TIMSS metric) for each of the TIMSS countries ***/										
									}																					/*** NOTE - aweights give same mean value as pweights ***/


*STEP 4 - GET Mean test scores																				
svyset School_ID [pw = Weight]
																				
foreach i of global countries_pisa {																		/*** CORRESPONDS TO RIGHT-HAND COLUMN OF TABLE 2 ***/	
									svy:mean Z_Math_Score  if Country==`i'										/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}									
									

*STEP 5 - GET STANDARD ERRORS FOR QUANTILES																	/*** Create a series of programmes that will enable me to get standard errors ***/
*Q10																										/*** These use quantile regression with an empty model to get standard errors for relevant percentiles ***/
*																										/*** CORRESPONDS TO RIGHT-HAND COLUMN OF TABLE 4B ***/				
capture program drop q10													
program q10
			qreg Z_Math_Score [aweight= Weight] if Country==`1' , q(0.10)													/***Q10***/
end
																											
foreach i of global countries_pisa {																		/*** CORRESPONDS TO RIGHT - HAND COLUMN OF TABLE 4A ***/	
									bs, cluster(School_ID): q10 `i'											/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}
									
* P90 ESTIMATES		
*																											/*** CORRESPONDS TO RIGHT-HAND COLUMN OF TABLE 4B ***/				
capture program drop q90
program q90
			qreg Z_Math_Score [aweight= Weight] if Country==`1' , q(0.90)									/***Q90***/
end
foreach i of global countries_pisa {								
									bs, cluster(School_ID): q90 `i'											/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}
						
	
bs, cluster(School_ID): q90 926
bs, cluster(School_ID): q90 927
	
/***								
*Q25
capture program drop q25
program q25
			qreg Z_Math_Score [aweight= Weight] , q(0.25)													/***Q25***/
end
	
*Q75							
capture program drop q75
program q75
			qreg Z_Math_Score [aweight= Weight] , q(0.75)													/***Q75***/
end
								
***/


*STEP 6 - SES analysis																									/*** SES + Books analysis ***/
svyset School_ID [pw = Weight]
foreach i of global countries_pisa {								
									xi:svy: regress Z_Math_Score i.Books*i.Immigrant i.Gender if Country==`i'				/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}


					
replace School_ID = School_ID*1000
keep Country_ID Year Z_Math_Score Weight School_ID 
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\PISA_2009\PISA_2009_For_Changes.dta", replace 		/*** Open the merged TIMSS 2007 data ***/














									








