****************
** JJ created 10/01/13
** JJ updated 10/01/13
***************

*STEP 1 - CHECK NOTHING HAS GONE WRONG WITH MERGING / RE-CODING
use "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_2007_MERGED_Alt.dta", clear  		/*** Open the merged TIMSS 2007 data ***/
set seed 984744	

label define Country 36 "Aus" 158 "Twn" 344 "Hkg" 348 "Hun" 360 "Ind" 380 "Ita" 392 "Jap" 440 "Ltu" /*		/*** Label countries ***/
*/ 578 "Nor" 643 "Rus" 702 "Sgp" 705 "Svn" 840 "USA" 926 "Eng" 927 "Sco", modify
label values Country Country

global countries_timss 36 158 344 380 392 440 578 643 702 705 840 926 927												/*** Create a global macro for each of the TIMSS countries ***/

tab Country

foreach i of global countries_timss {
									sum Math_Score1 [aw = Weight] if Country==`i' , d									/*** Distribution of math test scores (TIMSS metric) for each of the TIMSS countries ***/										
									}																					/*** NOTE - aweights give same mean value as pweights ***/

***Note mean scores should be as follows:
* AUS = 496, TWN = 598, HKG = 572 , Hun = XX , ITA = 480 , JAP = 570  , LTU = 506 ,
* NOR = 469 , RUS = 512 , SGP = 593, SVN = 501 , USA = 508, ENG = 513 , SCO = 487

***NOTE P75 should be as follows (see page 455 of http://timssandpirls.bc.edu/TIMSS2007/PDF/T07_M_IR_AppendixD.pdf) 	/*** NOTE - Figures one or two points different. As expected - I am using just one PV whereas the survey document uses all 5 PV's ***/
* AUS = 548 , TWN = 672 , HKG = 638 , Hun = XX , ITA = 532  , JAP = 628  , LTU = 561 ,									/*** Little substantive importance ***/
* NOR =  517, RUS = 569 , SGP = 661 , SVN = 550 , USA = 563 , ENG = 574  , SCO = 544

***NOTE P90 should be as follows (see page 455 of http://timssandpirls.bc.edu/TIMSS2007/PDF/T07_M_IR_AppendixD.pdf)
* AUS = 600 , TWN = 721 , HKG = 681 , Hun =  , ITA = 574 , JAP = 677  , LTU = 609 ,
* NOR = 552 , RUS = 617 , SGP = 706 , SVN = 594 , USA = 607  , ENG = 618 , SCO = 590


*STEP 2 - STANDARDISE ACROSS COUNTRIES

sum Math_Score1 [aw = Weight]											/*** Get distribution of maths test scores across pupils in all countries being considerred ***/
gen Mean_Math_Score1 = r(mean)											/*** Create new variable reflecting the cross-country mean score ***/
gen SD_Math_Score1 = r(sd)												/*** Create new variable reflecting the cross-country standard deviation ***/
tab Mean_Math_Score1
tab SD_Math_Score1

gen Z_Math_Score =  (Math_Score1 - Mean_Math_Score1) / SD_Math_Score1		/*** Create standardised score by subtracting cross -country mean and dividing by SD ***/
sum Z_Math_Score [aw = Weight], d											/*** Check distribution ***/


*STEP 3 - RESULTS FOR TIMSS 2007

foreach i of global countries_timss {
									sum Z_Math_Score [aw = Weight] if Country==`i' , d									/*** Distribution of math test scores (TIMSS metric) for each of the TIMSS countries ***/										
									}																					/*** NOTE - aweights give same mean value as pweights ***/



*STEP 4 - GET Mean test scores																				
svyset School_ID [pw = Weight]
																				
foreach i of global countries_timss {																		/*** CORRESPONDS TO MIDDLE COLUMN OF TABLE 2 ***/	
									svy:mean Z_Math_Score  if Country==`i'										/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}									
									
									
*STEP 5 - GET STANDARD ERRORS FOR QUANTILES																	/*** Create a series of programmes that will enable me to get standard errors ***/
*Q10	
*																										/*** These use quantile regression with an empty model to get standard errors for relevant percentiles ***/
capture program drop q10													
program q10
			qreg Z_Math_Score [aweight= Weight] if Country==`1' , q(0.10)													/***Q10***/
end
																											
foreach i of global countries_timss {																		/*** CORRESPONDS TO MIDDLE COLUMN OF TABLE 4A ***/	
									bs, cluster(School_ID): q10 `i'											/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}
									
* P90 ESTIMATES			
*																										/*** These use quantile regression with an empty model to get standard errors for relevant percentiles ***/																					/*** CORRESPONDS TO MIDDLE COLUMN OF TABLE 4B ***/				
capture program drop q90
program q90
			qreg Z_Math_Score [aweight= Weight] if Country==`1' , q(0.90)									/***Q90***/
end
foreach i of global countries_timss {								
									bs, cluster(School_ID): q90 `i'											/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}
														
/***								
*Q25
capture program drop q25
program q25
			qreg Z_Math_Score [aweight= Weight] , q(0.25)													/***Q25***/
end
	
*Q75							
capture program drop q75
program q75
			qreg Z_Math_Score [aweight= Weight] , q(0.75)													/***Q75***/
end
								
***/

*STEP 6 - SES analysis																									/*** SES + Books analysis ***/
svyset School_ID [pw = Weight]
foreach i of global countries_timss {								
									xi:svy: regress Z_Math_Score i.Books*i.Immigrant i.Gender if Country==`i'				/*** NOTE: Boot-strapping by cluster to get accurate SE's ***/
									}

					
replace School_ID = School_ID*1000
keep Country_ID Year Z_Math_Score Weight School_ID
save "C:\Users\John\Pictures\STATA_VERSION_9\East_Asia\Eighth_Grade_TIMSS_2007\TIMSS_2007_For_Changes.dta", replace 		/*** Open the merged TIMSS 2007 data ***/







