*** version 1.3 23oct2014

global regressions_command="cnsreg etregress glm intreg nl regress tobit truncreg" ///
	+" sem  stcox  streg biprobit cloglog  hetprobit logistic logit   probit scobit"  /// 
	+" clogit mlogit mprobit ologit oprobit slogit gnbreg nbreg poisson  tnbreg"  ///
	+" tpoisson zinb zip ivprobit ivregress ivtobit heckman heckoprobit heckprobit sureg" 

cap program drop repest
program define repest, eclass 
	gettoken left  right : 0,  parse(",")
	version 11	
	 // we must first deal with potential pv in the if statement in order to trick the syntax command
		local leftbis `:subinstr local left "@" "1", all'
		local nb_left: word count `left'
		forv k=1/`nb_left' {
			local step:word `k' of `left'
 			local list_with_arobas "`list_with_arobas' `step'"
			local list_without_arobas "`list_without_arobas' `=subinstr("`step'","@","1", .)'"
			}
	
	local 0 "`leftbis' `right'"
 	
 	syntax   name(name=svyname id="data name") [if] [in] ,  ESTimate(string) [ by(string) ///
		over(string) outfile(string) debug(string) results(string) flag display] 
		
// ----------------------Parsing of parameters and definition of local variables
// -------------------------------------------------commmon to the whole program
	global svyname= "`svyname'"
	tempname bvar VCOV beta beta_copy VCOV_copy V flags VCOV_d beta_d
	tempfile base_dataset by_level_dataset
	repest_parser  `svyname' `if' `in'  ,  estimate(`estimate') by(`by') over(`over') outfile(`outfile')   `display'  ifarobas(`list_with_arobas')
	foreach local_var in long_over command_type list_weight over_first over_last  rep_weight_name	final_weight_name  	varlist_to_keep  list_weight  overlevels by_levels by_var variancefactor  ///
			 NBpv pv_here average_levels by_var over_test over_var	type_out display filename command_options  command 	NREP pvvarlist {
		local `local_var' "`r(`local_var')'"
		}
	forv k=1/`nb_left' {  // we come back to the arobas syntax in the if statement when we have pv
			local step_wo:word `k' of `list_without_arobas'
			local step_wi:word `k' of `list_with_arobas'
			local if=regexr("`if'","`step_wo'","`step_wi'")
			}	
 	foreach global_var in  groupflag_name {
 			global  `global_var' "`r(`global_var')'"
		}
	tempname memhold_all
	tempfile results_all
	local hasposted_ever=0
	foreach mat in bvar_d beta_d beta  bvar {
	local `mat'_list=""
	forval ip = 1(1)`NBpv' {
		if `pv_here'==0 local ip=""
		tempname `mat'`ip' 
		local `mat'_list "``mat'_list' ``mat'`ip''"
		}
	}
	preserve
	qui keep `varlist_to_keep'
	if "`by_var'" != "" qui tostring `by_var', force replace
	qui save `base_dataset'
	
// -----------------------------------------------------------------------------
// -----------------------------------------Beginning of the loop over by_levels
			
			//---------------------the loop runs once if the option is irrelevant
			//-------------------------------(by_level, over_levels, pv values),
			//-----------------------------------for all these nested loops 
					
foreach by_level in `by_levels' {

	qui use `base_dataset',clear
	local error_everywhere_level="yes"
	local error_test=0
	tempname memhold_errors memhold_bylevel
	if "`flag'"!="" tempname flag_bylevel flag_bylevel_d
	tempfile by_level_dataset results_bylevel errors_bylevel  
	qui postfile `memhold_errors' str20(`by_var' over_value)  using `errors_bylevel', replace
	if "`by_var'" != "" qui keep if `by_var' == "`by_level'" //by_var must be string
 	qui save `by_level_dataset', replace
	
	// -------------------------------------------------------------------------
	// -----------------------------------Beginning of the loop over over_levels
 
	foreach over_level in `overlevels' {
		if "`over_level'" == "NoOver"  {
			qui use `by_level_dataset', clear
			dis as result _n "`by_level'" _c
		}
		else dis as result _n "`by_level'" " - `over_var' = " "`over_level'" " " _c
		// ---------------------------------------------------------------------
		// --------------------------Beginning of the loop over plausible values
		 
		forval ip = 1(1)`NBpv' {
			if `pv_here'==0 local ip=""
			di "." _c
			foreach param in command command_options results over_var if {
				local `param'_loop: subinstr local `param' "@"  "`ip'", all
				}
			if regexm("`over_var'","@") == 1 { // if over_var is pvvar change sample at each pv
				qui use `by_level_dataset', clear
				qui keep  if `over_var_loop' == `over_level'
				}
			else if "`over_level'" != "NoOver"  {	// else load sample at first pv only
				if "`ip'" == "1" | "`ip'" == ""{					
					qui use `by_level_dataset', clear
					qui keep  if `over_var' == `over_level'
					}
				}
			// -----------------------------------------------------------------	
			// -------------------------------Beginning of the loop over weights
									
									//We build here the (nb PV) matrices of (nb BRR) 
									//replicated estimates which are the raw material
									//for the computation of SE (bvar). Same for point 
									//estimates, done with the final  weight (beta)
									//We pass the flag option only for the first
									//turn of this loop and for the first PV
			
			foreach current_weight in `list_weight' {
				ereturn clear
									//n_commands compute themselves flags
				if "`current_weight'"=="`final_weight_name'" & ("`ip'"=="" | "`ip'"=="1") & "`flag'"!="" & "`command_type'"=="special" & "`command_options_loop'"!="" local flag_loop="flag"
				else if "`current_weight'"=="`final_weight_name'" & ("`ip'"=="" | "`ip'"=="1") & "`flag'"!="" & "`command_type'"=="special" & "`command_options_loop'"=="" local flag_loop=", flag"
				else local flag_loop=""
  				  cap qui    `command_loop' `if_loop' `in' [aw = `current_weight'] `command_options_loop' `flag_loop' //Core of the program
				if _rc==101 {
   				 cap qui `command_loop' `if_loop' `in' [pw = `current_weight'] `command_options_loop' `flag_loop' //Core of the program
				}
				local error_estimate=(_rc!=0)
				if `error_estimate'==0 {
					local error_everywhere_level="no"
									//flags for e_commands are computed based on 
									//e(sample) with a special consideration for
									// dummies in regressions.
					if "`current_weight'"=="`final_weight_name'" & ("`ip'"=="" | "`ip'"=="1") & "`flag'"!="" local flag_loop="flag"
					else local flag_loop=""
 					repest_read_flag_results , beta(`beta`ip'') bvar(`bvar`ip'') results(`results_loop') ip("`ip'") pv_here(`pv_here')  current_weight(`current_weight') rep_weight_name(`rep_weight_name') final_weight_name(`final_weight_name')  `flag_loop' pvvarlist(`pvvarlist') 
					if "`current_weight'"!="`final_weight_name'" matrix `bvar`ip'' = r(bvar_post)
					else if "`current_weight'"=="`final_weight_name'" {
						if "`colnames'"=="" local colnames "`r(colnames)'"
						matrix `beta`ip'' = r(beta_post)
 						if ("`ip'"=="" | "`ip'"=="1") & "`flag'"!="" matrix `flag_bylevel'=r(flags)
						if "${svyname}" == "PIAAC" {
							repest_PIAAC_variancefactor `if_loop' `in' [aw = `current_weight'], nrep(`NREP') // check if JK1, JK2 or pooled
							local variancefactor = r(variancefactor)
							}
						
						}
 					if "`colnames'"=="" local colnames "`r(colnames)'"
					}
					
				else if `error_estimate'==1 {
					if "`over_level'"=="`over_last'" | "`over_level'"=="`over_first'" local error_test=1
					continue, break	
					}
				}
			// -------------------------------------End of the loop over weights
			// -----------------------------------------------------------------
			
									//We create the difference between extreme
									//values of over if requested and 
									//return matrices of BRRs
									// two steps here: 1st, when over_level=first
									// ; when over_level=last
									
			if "`over_test'"!="" & "`error_test'"!="1" & ( "`over_level'"=="`over_first'" | "`over_level'"=="`over_last'") {
				repest_create_diff,overlevel(`over_level') overfirst(`over_first') overlast(`over_last') beta(`beta`ip'') bvar(`bvar`ip'') beta_diff(`beta_d`ip'') bvar_diff(`bvar_d`ip'') flag_d(`flag_bylevel_d')  flag(`flag_bylevel')
				matrix `bvar_d`ip''= r(bvar_return)
				matrix `beta_d`ip''= r(beta_return)
				if "`flag'"!="" matrix `flag_bylevel_d'= r(flags)
				}
			}	

		// --------------------------------End of the loop over plausible values
		// ---------------------------------------------------------------------
 									//we gather all BRRs to compute estimates and 
									//their standard errors and post these estimates
									//in a  by-level specific dta temporary file
		if  "`error_estimate'"!="1" {
 			repest_create_beta_vcov, bvarlist("`bvar_list'") betalist("`beta_list'") pvhere("`pv_here'") nbpv(`NBpv') variancefactor(`variancefactor') `fast' 
			matrix `VCOV' = r(VCOV)
			matrix `beta' = r(beta)
			repest_post_memhold_bylevel, vcov("`VCOV'") beta("`beta'") memname("`memhold_bylevel'") by_level(`by_level') over_level(`over_level')  tempdata("`results_bylevel'") colnames(`colnames') by_var(`by_var') flag(`flag_bylevel')
			}
		else if  "`error_estimate'"=="1" post `memhold_errors' ("`by_level'") ("`over_level'") 
		}
		
	// -----------------------------------------End of the loop over over_levels
	// -------------------------------------------------------------------------
	
									//If requested, we compute estimates and 
									//their standard errors for the difference
									//and post them
												
		if "`over_test'"!="" & "`error_test'"!="1" {
			repest_create_beta_vcov, bvarlist("`bvar_d_list'") betalist("`beta_d_list'") pvhere("`pv_here'") nbpv(`NBpv') variancefactor(`variancefactor') `fast'
			matrix `VCOV_d' = r(VCOV)
			matrix `beta_d' = r(beta)
			repest_post_memhold_bylevel, vcov("`VCOV_d'") beta("`beta_d'") memname("`memhold_bylevel'") by_level(`by_level') over_level(d) flag(`flag_bylevel_d')
			}
		else if "`over_test'"!=""	post `memhold_errors' ("`by_level'") ("d") 
									
									//If there has been any successful estimation
									//for the by_level we reshape the results 
									// database (all statistics for all over_levels
									// in a given by_level in one line
									// and display them if requested
									
	if "`error_everywhere_level'"=="no" {
		postclose `memhold_bylevel' 
		postclose `memhold_errors'
		qui use `results_bylevel', clear
		append using `errors_bylevel'
		if "`over_var'"==""	 drop over_value
		qui save `results_bylevel', replace
		if "`over_var'"!="" {
			if "`by_var'" == "" local by_var "_pooled"
			repest_results_reshape, over_var(`over_var') by_var(`by_var') replacefile(`results_bylevel')
			}
		if "`display'"=="display" repest_display_bylevel, results_bylevel(`results_bylevel') over_var(`over_var') by_var(`by_var') by_level(`by_level') vcov(`VCOV')
		if "`long_over'"=="" 		qui save `results_bylevel', replace

		if	"`hasposted_ever'"=="1" {
			qui use `results_all', clear
			append using `results_bylevel'
			qui save `results_all',replace
			}
		else if "`hasposted_ever'"=="0" {
			qui	save `results_all', replace
			local hasposted_ever=1
			}		
		
		}
	else if	"`error_everywhere_level'"=="yes" display "there were no successful estimates for `by_var' = `by_level'. Consider debugging the command within the estimate option"
}		

// -----------------------------------------------End of the loop over by_levels
// -----------------------------------------------------------------------------
									//If requested we computed averages of stats
									// over by_levels and post it
if "`average_levels'"!="" {
	tempfile results_average
	repest_compute_averages, data_source(`results_all') data_output(`results_average') average_levels(`average_levels') by_var(`by_var') 
	if "`display'"=="display" repest_display_bylevel, results_bylevel(`results_average') over_var(`over_var') by_var(`by_var') by_level(`average_levels') average
	qui use `results_all', clear
	append using `results_average'
	qui save `results_all',replace

	}
	
	if "`outfile'" != ""  {
		qui use `results_all', clear
		qui save `filename', replace
		*list
	}
restore	

end
	
	

* *******************
* Auxiliary Macros *
* *******************


cap program drop repest_compute_averages
program define repest_compute_averages	
	syntax,  data_source(string) data_output(string) average_levels(string) by_var(string)
	
	qui use `data_source'
 	keep if regexm("`average_levels'",`by_var')
 	foreach var of varlist *_se {
				qui replace `var'=`var'*`var'
		qui gen `var'_nb=(`var'!=.)
	}
	collapse (mean) *_b (sum) *_se *_se_nb
	
	foreach var of varlist *_se {
		qui replace `var'=sqrt(`var')/`var'_nb
		}
	drop *_se_nb
	qui gen `by_var'="average"
 	qui save `data_output',replace
	
end

cap program drop regexr_allmatch
program define regexr_allmatch,rclass
syntax, expression(string)  toreplace(string) [replacement(string)]

while regexm("`expression'","`toreplace'")==1 {	
	local expression=regexr("`expression'","`toreplace'","`replacement'")
	}
return local expression="`expression'"
end
	
	 
cap program drop repest_display_bylevel
program define repest_display_bylevel
	syntax, results_bylevel(string)  by_level(string) [by_var(string) over_var(string) vcov(string) average]
	tempname beta_display se_display 
	qui use `results_bylevel'
 	mkmat *_b, matrix(`beta_display')
 	mkmat *_se, matrix(`se_display')
	local colfullnames=""
	forv i=1/`=colsof(`beta_display')' {
		local omit_flag=((`beta_display'[1,`i'])==. | (`beta_display'[1,`i'])==.f | (`se_display'[1,`i'])==.)
		if "`omit_flag'"=="1" matrix `beta_display'[1,`i']=0
		if "`omit_flag'"=="1" {
			matrix `se_display'[1,`i']=0
			if "`vcov'"!="" & "`over_var'"=="" {
				forv j=1/`=colsof(`beta_display')' {
					matrix `vcov'[`j',`i']=0
					matrix `vcov'[`i',`j']=0
					}
				}	
		}
		local word: word `i' of `:colnames `beta_display''
		if regexm("`word'","(.+)_(`over_var'.+)(_b)")==1 & "`over_var'"!="" {
			if "`omit_flag'"=="1" local colfullnames "`colfullnames'`=regexs(2)':o.`=regexs(1)' "  
			if "`omit_flag'"=="0" local colfullnames "`colfullnames'`=regexs(2)':`=regexs(1)' " 
			}
		else if  "`omit_flag'"=="1" local colfullnames "`colfullnames'o.`=regexr(`"`word'"',"_b$","")' "
		else local colfullnames "`colfullnames'`=regexr(`"`word'"',"_b$","")' "
		}
 
 	matrix `se_display'=diag(`se_display')*diag(`se_display')
 	matrix colnames `beta_display'= `colfullnames'
 	matrix colnames `se_display'= `colfullnames'
	matrix rownames `se_display'= `colfullnames'
	dis _n "`by_var'" " : " "`by_level'"
	if "`over_var'"=="" & "`average=='"=="" {
		 	matrix colnames `vcov'= `colfullnames'
			matrix rownames `vcov'= `colfullnames'
			
			ereturn post `beta_display' `vcov'
	}
	else{
		
		ereturn post `beta_display' `se_display'
	}
	
	if _rc == 504 di as error " ereturn post: matrix has missing values " _c
	else {
		
		ereturn display  
	}
end


cap program drop repest_results_reshape
program define repest_results_reshape,
	syntax, over_var(string) by_var(string) [replacefile(string)]
	local list_reshape=""
	local over_short = strtoname(abbrev("`over_var'",7))
	foreach var of varlist *_se *_b {
		if regexm("`var'","(.*)((_b)|(_se))")==1 {
			qui rename `var' `=regexs(1)'_`over_short'_`=regexs(2)'
			local list_reshape "`list_reshape' `=regexs(1)'_`over_short'_@`=regexs(2)'"
			}
		}	
	qui reshape wide `list_reshape', i(`by_var') j(over_value)	string
	if "`replacefile'"!="" qui save `replacefile' ,replace
	
end

cap program drop repest_create_diff
program define repest_create_diff,rclass
syntax, overlevel(string) overfirst(string) overlast(string) beta(string) bvar(string) beta_diff(string) bvar_diff(string) [flag(string) flag_d(string)]
	tempname bvar_return beta_return flags
				if "`overlevel'"== "`overfirst'" {
					matrix `bvar_return'= -`bvar'
					matrix `beta_return'= -`beta'
					if "`flag'"!="" matrix `flags'=`flag'
					}
				if "`overlevel'"== "`overlast'" {
					matrix `bvar_return'=  `bvar_diff'+`bvar'
					matrix `beta_return'= `beta_diff'+`beta'
					if "`flag'"!="" matrix `flags'=`flag'+`flag_d'
					}	
				return matrix bvar_return=`bvar_return'	
				return matrix beta_return=`beta_return'	
				if "`flag'"!="" return matrix flags=`flags'

	end
	
cap program drop repest_read_flag_results
 program define repest_read_flag_results ,rclass
 syntax, current_weight(string) rep_weight_name(string) final_weight_name(string) beta(string) bvar(string)  [ results(string) ip(string) pv_here(string) flag pvvarlist(string) ]
	tempname bvar_post	beta_post flags
		local error_everywhere_level="no"
		repest_getresults, est_list(b) `results' //format the previous ereturn
		local combine "`r(combine)'"
		local raw_statlab_list "`r(statlab_list)'"
		local colnames "`r(statlab_list)'"
		if "`pv_here'"=="1" {
			foreach pvvar in `pvvarlist' {
				local pvparm = regexr("`pvvar'","@","`ip'")
				local pvlabel = regexr("`pvvar'","@","_")
				local colnames : subinstr local colnames "`pvparm'"  "`pvlabel'", all
				}
			}
		else local colnames "`r(statlab_list)'"
		local nbcol :  word count "`colnames'" 
		if "`current_weight'"=="`final_weight_name'" matrix `beta_post' = r(stats)
		else if "`current_weight'"=="`rep_weight_name'1" matrix `bvar_post' = r(stats) - `beta'
		else matrix `bvar_post' = [`bvar' \ r(stats) - `beta']
		if "`flag'"!="" &  "`e(flags)'"!="" matrix `flags'=e(flags)
 		else if "`flag'"!="" &  "`e(flags)'"=="" & regexm("${regressions_command}", "`e(cmd)'")==0 {
 			repest_flags if e(sample)==1
			matrix `flags'=J(1,`nbcol',`r(flag)')
			}
		else if "`flag'"!="" &  "`e(flags)'"=="" & regexm("${regressions_command}", "`e(cmd)'")==1 {
 			repest_flags   if e(sample)==1
			foreach stat in `raw_statlab_list' {
						scalar `stat'_f= `r(flag)'
						if "`flag_list'"=="" {
						local flag_list "`stat'_f"
							}
						else {
							local flag_list "`flag_list' , `stat'_f"
							}
						}
			foreach regressor in `:colnames e(b)' {
					foreach stat in `raw_statlab_list' {
					if regexm("`stat'","`regressor'")==1 & "`regressor'"!="_cons" {
							repest_flags `regressor' if e(sample)==1, binarytest
							scalar `stat'_f= `r(flag)'
						}
					 
					}
				}
 
 				matrix `flags'=[`flag_list']
 			}
 		if "`combine'" != "" & "`flag'"!="" {
 			tokenize "`combine'", parse(",")
			local current 1
			while "``current''" != "" {
				if "``current''" != "," {
					gettoken name `current' : `current',  parse(":")
					gettoken equals myexp : `current',  parse(":")
					local flag_combine=0
					if `"`name'"'==":" {
						di as error `"invalid name"'
						exit 198
						}
					capture confirm name `name'
					if _rc {
						di as err `"invalid name: `name'"'
						exit 198
						}
					local nstats:   word count `colnames'
					forval i = 1/`nstats' {
						local stat: word `i' of `colnames'
						if regexm(`"`myexp'"',"_b\[`stat'\]")==1 	local flag_combine=`=max(`flag_combine', `flags'[1,`i'])'
						if "`stat'"=="`name'" {
							cap matrix `flags'[1,`i']=`flag_combine'
								if _rc==503  matrix `flags'=[`flags',`flag_combine']
							}
						}
										
				local current = `current' + 1
				}
			}
 			}
 	
		if  "`flag'"!="" return matrix flags=`flags'
		if "`current_weight'"!="`final_weight_name'" return matrix bvar_post=`bvar_post'				
		if "`current_weight'"=="`final_weight_name'" return matrix beta_post=`beta_post'
		return local colnames "`colnames'"									
end

cap program drop repest_flags
program define repest_flags,rclass
	syntax [varlist(default=none)]  [if] [in] [pweight aweight]  ,    [mingroups(integer 5) minind(integer 30) binarytest] 
  	if "`varlist'"!="" {
		if "`if'"!="" local if="`if' & `varlist'!=."
		if "`if'"=="" local if="if `varlist'!=."
		}
	if  "`binarytest'"!="" & "`varlist'"!="" {
		qui su `varlist' `if'
		local min_value=r(min)
		local max_value=r(max)
		capture assert inlist(`varlist',`min_value',`max_value') if `varlist'!=.
		local isbinary= (_rc==0)
		}
	if "${svyname}"=="PISA" {	
		if "`binarytest'"!="" & "`isbinary'"=="1" & "`varlist'"!="" {
			qui count  `if' & `varlist'==`min_value'
			local nobs0 = r(N)
			cap tab ${groupflag_name}   `if' & `varlist'==`min_value', nofreq
			local ngrp0 = r(r)
			qui count  `if' & `varlist'==`max_value'
			local nobs1 = r(N)
			cap tab ${groupflag_name}  `if' &  `varlist'==`max_value', nofreq
			local ngrp1 = r(r)
			return local flag = (`nobs1' < `minind' | `ngrp1' < `mingroups' | `nobs0' < `minind' | `ngrp0' < `mingroups' )
			}
		else  {
			qui	count  `if'
			local nobs = r(N)
			qui tab ${groupflag_name} `if' , nofreq
			local ngrp = r(r)
			return local flag = (`nobs' < `minind' | `ngrp' < `mingroups'  )
			}
		}	
	if "${svyname}"=="PIAAC" {			
		if "`binarytest'"!="" & "`isbinary'"=="1" & "`varlist'"!="" {
			qui count  `if' & `varlist'==`min_value'
			local nobs0 = r(N)
			
			qui count  `if' & `varlist'==`max_value'
			local nobs1 = r(N)
			
			return local flag = (`nobs1' < `minind'  | `nobs0' < `minind')
			}
		else  {
			qui	count  `if'
			local nobs = r(N)
			return local flag = (`nobs' < `minind'   )
			}
		}	
 end


cap program drop repest_create_beta_vcov
program define repest_create_beta_vcov,rclass
		syntax , bvarlist(string) betalist(string) pvhere(string) nbpv(integer) variancefactor(real)  [fast]
			tempname bvar_bis beta VCOV
				forv ip = 1(1)`nbpv' {
					mata :	`bvar_bis' = (st_matrix("`=word(`"`bvarlist'"', `ip')'"))
					mata: st_matrix("`=word(`"`bvarlist'"', `ip')'",(`bvar_bis''*`bvar_bis')*`variancefactor')
					}
				if "`pvhere'"=="1" {
					
					repest_PVvariance, nbpv(`nbpv') betas(`betalist') vcovs(`bvarlist') `fast'
					matrix `VCOV'= r(VCOV)
					matrix `beta' = r(beta)
					return matrix VCOV = `VCOV'
					return matrix beta = `beta'
				}
				else {
					return matrix VCOV = `bvarlist'
					return matrix beta = `betalist'
				}
end

cap program drop repest_gen_memhold_bylevel	
program define repest_gen_memhold_bylevel,rclass
	syntax, tempdata(string) memname(string) colnames(string) [by_var(string)]
	if "`by_var'" == "" local by_var "_pooled"
	local output_names ""
			foreach name in `colnames' {
				local lab=strtoname(abbrev("`name'",18))
				local output_names  "`output_names' `lab'_b `lab'_se "
 				}
		qui postfile `memname' str20 `by_var' str20 over_value  double(`output_names') using `tempdata', replace
	end		

cap program drop repest_post_memhold_bylevel	
program define repest_post_memhold_bylevel
	syntax, memname(string) beta(string) vcov(string) by_level(string) over_level(string) [tempdata(string) colnames(string) by_var(string) flag(string)]
	tempname se
	mata: `se'= sqrt(diagonal(st_matrix("`vcov'")))
	mata: st_matrix("`se'",`se'') //we must transpose
	local output ""
	local nc = colsof(`beta')
	if "`flag'"!=""{
		forval i = 1/`nc' {
			if `flag'[1,`i'] {
				matrix `beta'[1,`i']==.f
				matrix `se'[1,`i']==.f
				}
			}
		}
	forval i = 1/`nc' {
		local output "`output' (`beta'[1,`i']) (`se'[1,`i'])"
		}
		
	cap post `memname' ("`by_level'") ("`over_level'") `output'  
	if _rc!=0 {
		repest_gen_memhold_bylevel , tempdata(`tempdata') memname(`memname') colnames(`colnames') by_var(`by_var')
		local over_label  "`over_level'"
		post `memname' ("`by_level'") ("`over_label'") `output'  	
		}
			
end
		 
cap program drop repest_parser
program define repest_parser, rclass
	syntax   name(name=svyname id="data name") [if] [in] [ ,  estimate(string) by(string) ///
	over(string) outfile(string)  display  ifarobas(string) ] 
	*estimate
	if substr("`estimate'",1,5)=="stata" {
		gettoken trash  command  : estimate , parse( ":")
		gettoken command  command_options : command,  parse(",")
		gettoken trash  command : command,  parse( ":") // we get rid of the ":" in the command option

		}
	else if regexm("`estimate'","(^summarize)|(^freq)|(^means)|(^quantiletable)|(^corr)") {
	gettoken command  command_options :  estimate , parse( ",")
		local command  "repest_`command'"
 		local command_type="special"
		}	
	else {
		error 198
		}
	
	if regexm("`estimate'","^freq") & regexm("`command_options'", "levels\(")==0 {
			if regexm("`command'","(.*)(freq)(.*)") local varname=regexs(3)
			local varname=regexr("`varname'","@","1")
			qui levelsof `varname', local(temp) clean
			if "`command_options'"!="" local command_options "`command_options' levels(`temp')"
			else   local command_options ",levels(`temp')"
 			}
	*other parameters
	gettoken filename type_out : outfile, parse(",")
	if "`filename'"=="" local display "display" // if no outfile requested, display results
	gettoken trash type_out : type_out, parse(",")	// we get rid of the "," in the type option
	gettoken over_var over_test : over, parse(",")
	gettoken trash over_test : over_test, parse(",") // we get rid of the "," in the over_levels option
	gettoken by_var by_options : by, parse(",")
	gettoken outfile outfile_options : outfile, parse(",")
	if regexm("`outfile_options'","long_over")==1 local long_over="long_over"
	
	if regexm("`by_options '","levels\(([^\)]*)")   local by_levels=regexs(1)
	if regexm("`by_options '","average\(([^\)]*)")   local average_levels=regexs(1)
 	local pv_here=regexm("`estimate' `ifarobas' `over_var'","@")
 	*we define here also PISA, PIAAC, TALIS, ALL and IALS parameters
		*NBpv tells how many turns the main loop has. it's only one loop when there are no variable with plausible values
		if "${svyname}"=="PISA" {
			local NBpv=5*(`pv_here'==1)+1*(`pv_here'==0)
			local final_weight_name="w_fstuwt"
			local rep_weight_name="w_fstr"	
			local variancefactor=1/20
			local NREP = 80
			local groupflag_name="schoolid"
			local keepsvy "cnt schoolid"
				}
		else if "${svyname}"=="TALISTCH" {
			local NBpv=1
			local final_weight_name="tchwgt"
			local rep_weight_name="trwgt"	
			local variancefactor=1/25
			local NREP = 100
			}
		else if "${svyname}"=="TALISSCH" {
			local NBpv=1
			local final_weight_name="schwgt"
			local rep_weight_name="srwgt"	
			local variancefactor=1/25
			local NREP = 100
			}
		else if "${svyname}"=="PIAAC" {
			local NBpv=10*(`pv_here'==1)+1*(`pv_here'==0)
			local final_weight_name="spfwt0"
			local rep_weight_name="spfwt"	
			local variancefactor=. //set later
			local NREP = 80
			local keepsvy "vemethodn"
			}
		else if "${svyname}"=="ALL" | "${svyname}"=="IALS" {
			local NBpv=10*(`pv_here'==1)+1*(`pv_here'==0)
			local final_weight_name="popwt"
			local rep_weight_name="REPLIC"	
			local variancefactor = 1 
			local NREP = 30
			}
		else error 198
		
	if "`by_levels'"=="" {
		if "`by_var'" != "" {
			levelsof `by_var', local(by_levels) 
			}
		else local by_levels  = "_pooled"
		}
	local by_levels : list clean by_levels
	
	if "`over_var'" != "" {
		if regexm("`over_var'","@") == 1 	local over_var_test = regexr("`over_var'","@","1")
		else local over_var_test "`over_var'"
		cap confirm numeric variable `over_var_test'
		if !_rc {
			qui levelsof `over_var_test', local(overlevels)
			local over_first =  word("`overlevels'",1)
			local over_last =  word("`overlevels'",-1)
			di as result " over `over_var' = `overlevels' " 
			}
		else di as error "option over() only allows numeric variables"
		}
	else 	local overlevels="NoOver"
		
	*we get the list of all weights rep and final
		local list_weight "`final_weight_name'"
		forv i=1/`NREP'  { 
			local list_weight  "`list_weight' `rep_weight_name'`i'"
			}
		local 	varlist_to_keep "`list_weight'"
		
			***we define the list of variables to keep 
		*to be adapted to PIAAC and PISA
		
		*we screen the estimate and if options looking for variable names
		local list_words_command   "`estimate' `ifarobas'"
		// punctuation marks 
		foreach op in ( ) , = & | < > !{ 
			local list_words_command: subinstr local list_words_command  "`op'"  " ", all			
			}
		// fvvarlist operators: 
		foreach op in c. # {
			local list_words_command: subinstr local list_words_command  "`op'"  " ", all
			}
		foreach word in `list_words_command' `over_var' {
		// fvvarlist operators: 
			local test = 0
			if regexm("`word'","(^[i|o][^\.]*)\.(.*)") {
				local word 	= regexs(2)	
				local test = 1
				} 
				
			* we expand lists of plausible values
			if regexm("`word'","@") == 1 {
				local pvvarlist   "`pvvarlist' `word'"
				forv i=1/`NBpv' { //we generate plausible value variables names
					local var_to_keep=subinstr("`word'","@","`i'", .) 
					local varlist_to_keep "`varlist_to_keep' `var_to_keep'"
					}
				}
			else {
				capture confirm variable `word' 
				if _rc==0 local varlist_to_keep  "`varlist_to_keep' `word'"
				}
			// words with varlist operators are varlists
			if regexm("`word'","\*") == 1 | regexm("`word'","\?") == 1 | regexm("`word'","-") == 1 | regexm("`word'","~") == 1 {
				local varlist_to_keep "`varlist_to_keep' `word'"
				}
			}

		local varlist_to_keep "`varlist_to_keep' `by_var' `keepsvy' "
	*string
	foreach output in long_over command_type groupflag_name overlevels by_levels by_var   rep_weight_name over_first over_last ///
			final_weight_name   average_levels by_var over_test over_var	type_out display filename command_options   ///
			command	varlist_to_keep	list_weight pvvarlist{
		return local `output' "``output''"
		}
	foreach output in		pv_here  variancefactor NBpv NREP{
			return local `output'=``output''
		}
end

cap program drop repest_PIAAC_variancefactor
program define repest_PIAAC_variancefactor, rclass
	syntax [if] [in] [aweight]  [,  nrep(integer 80)] // check if JK1, JK2 or pooled

	qui tab1 vemethodn `if' `in'
	if r(r) == 1 {		// if all obs are either JK1 or JK2
		if vemethodn[1] == 1 local variancefactor = (`nrep'-1)/`nrep'
		if vemethodn[1] == 2 local variancefactor = 1
		}
	else {				// if JK1 and JK2 countries are pooled
		tempvar sample
		cap gen `sample' = e(sample) `if' `in'
		qui levelsof `sample'
		if "`r(levels)'" == "0 1"  { 	// if estimation command sets sample, and some obs are excluded
			su vemethodn [aw `exp'] if `sample' `in', meanonly
			}
		else { 						// if estimation command does not set sample, or all obs are excluded
			su vemethodn [aw `exp'] `if' `in', meanonly
			}
		local variancefactor = (`nrep'-(2-r(mean)))/`nrep'
		}
	return scalar variancefactor = `variancefactor'
end
cap program drop repest_getresults
program define repest_getresults , rclass
	syntax , est_list(string) [Keep(string) Add(string) COMbine(string)]
	cap confirm matrix e(b)
	if _rc == 111 di as error "option estimate does not contain an estimation command; only eclass commands that set e(b) can be used"
 	local stats_list=""
	local statlab_list=""
	local quot `"""'
	local command= "`e(cmdline)'"
	gettoken trash cmdoptions : command ,parse(",")
	gettoken trash cmdoptions : cmdoptions ,parse(",")
	local eform=0
	foreach eform_options in `" eform\("' `" eform "' `" hr "' `" shr "' `" irr "' `" or "' `" rrr "' {
		if regexm(" `cmdoptions' ","`eform_options'")==1 local eform=1
		}
		
	***
	local b_names : colfullnames e(b)
	tempname res
	local res_names : subinstr local b_names ":"  "_", all
	matrix `res' = e(b)
	local n = colsof(`res')
	*we replace omitted estimation by a blank value
	forv i=1/`n' {
		local step :word `i' of `res_names'
		if regexm("`step'" , "o\.")==1 matrix `res'[1,`i']==.

		}	
		
 	local res_names :subinstr local res_names "o." ""  ,all 
	local res_names :subinstr local res_names "." "_"  ,all
	matrix colnames `res' = `res_names'
	matrix coleq `res' = ""
	***
	if  "`keep'"!="" {
		local res_names="`keep'"
		}
	tempname results
 
 	foreach stat in `est_list' `add'{
			if  "`stat'"=="b" {
			foreach coef in `res_names' {
			if `eform'==1 {
					local nb_word: word count `res_names'
					forval i = 1/`nb_word' {
						local step: word `i' of `res_names'
						if "`step'"=="`coef'" {
							if "`stats_list'"=="" {
								local lamf= `"  exp(`res'[1,`i'])"'
									}
								else {
									local lamf= `", exp(`res'[1,`i'])"'
								}
 							local stats_list "`stats_list' `lamf'" 
							}
						}
					}
				else {
					if "`stats_list'"=="" {
								local lamf= `" `res'[1,""' + `"`coef'"' +`""]"'
								
									}
								else {
									local lamf= `", `res'[1,""' + `"`coef'"' +`""]"'
								}
 					local stats_list `"`stats_list' `lamf'"'  
					}

				}
				
			 
			}
		else {	
				if "`stats_list'"=="" {
								local lamf `"`=e(`stat')'"'
									}
								else {
									local lamf= `", `=e(`stat')'"'
								}
				 if "`res_names'"=="" {
								local lamf_title `"e_`stat'"'
									}
								else {
									local lamf_title `", e_`stat'"'
								}			
 				local stats_list `"`stats_list' `lamf'"'
				local res_names "`res_names' e_`stat'"
			}
		}	
 	local res_names `:subinstr local res_names "," ""  ,all' 
	local res_names `:subinstr local res_names "o." ""  ,all'
 	matrix `results'=[`stats_list']
	matrix colnames  `results' = `res_names'	
	****
	* combination of results:
	if "`combine'" != "" {
			tokenize "`combine'", parse(",")
	
			local current 1
 			while "``current''" != "" {
				if "``current''" != "," {
					gettoken name `current' : `current',  parse(":")
					gettoken equals myexp : `current',  parse(":")
					if `"`name'"'==":" {
						di as error `"invalid name"'
						exit 198
						}
					capture confirm name `name'
					if _rc {
						di as err `"invalid name: `name'"'
						exit 198
						}
					local nstats: word count `res_names'
					forval i = 1/`nstats' {
						local stat  :word `i' of `res_names'
						local myexp : subinstr local myexp "_b[`stat']" "`results'[1,`i']", all
						}
						
					tempvar `name'
					matrix ``name'' = `myexp'
					local colnames_results : colnames `results'
					matrix `results' = [`results',``name'']
					local res_names  "`res_names' `name'"
					matrix colnames `results'  = `colnames_results' `name'
					}
				local current = `current' + 1
				}
			}
 	****
 

	local coln= colsof(`results')
	return scalar ncoeff =`coln'
	return local combine "`combine'"
	return matrix stats =`results'
	return local statlab_list "`res_names'"
end
 

cap program drop repest_PVvariance
program define repest_PVvariance, rclass
	syntax , nbpv(integer) betas(string) vcovs(string) [, fast] 
	
	if (wordcount("`betas'") !=  wordcount("`vcovs'")) | wordcount("`betas'") != `nbpv' {
		error 197
		}
	tokenize `vcovs'
 
 	local sum_beta = subinstr(trim("`betas'"), " ", " + ", .)
 	local sum_vcov = subinstr(trim("`vcovs'"), " ", " + ", .)
 
	tempname b b_dev IMPV SV VCOV
	matrix `b' = (`sum_beta') / `nbpv'
	foreach beta in `betas' {
		local dev_beta = "`dev_beta'" + "(`b' - `beta')" + " \ "
		}
	local dev_beta = regexr("`dev_beta'", "\\.$" ,"")
	matrix `b_dev' = (`dev_beta')
	matrix `IMPV' = (`b_dev'' * `b_dev') / (`nbpv' - 1)
	if "`fast'" == "" matrix `SV' = (`sum_vcov') / `nbpv'
 	else matrix `SV' = `1' 
	matrix `VCOV' = `SV' + ((`nbpv' + 1)/`nbpv') * `IMPV'
 	return matrix beta = `b'
	return matrix VCOV = `VCOV'
end


cap program drop repest_replace_omit_res 
program repest_replace_omit_res , rclass
	syntax namelist(name = beta id = "beta")
	* we deal with omitted statistics:
	local nb_cols=colsof(`beta')
	local betanames : colfullnames `beta'
	local new_betanames=""
	forv i=1/`nb_cols' {
		local step: word `i' of `betanames'
		if `beta'[1,`i']==. {
			matrix `beta'[1,`i']=0
			if  regexm("`step'", "\:" ) {
					local new_betanames "`new_betanames' `=regexr("`step'", "\:", ":o.")' "
					}
				else {
					local new_betanames "`new_betanames' o.`step'"
					}
			}
		else local new_betanames "`new_betanames' `step'"
		}
	return matrix beta = `beta'
 

	return local betanames  "`new_betanames'"
 
end

* ***** *
* MEANS *
* ***** *

cap program drop  repest_means
program define  repest_means, eclass
	syntax varlist [if] [in] [aweight pweight] [, flag pct]

	local pct =  ("`pct'"!="")
 
	foreach var in `varlist' {
	 
		cap confirm numeric variable `var'
		if !_rc {
			tempname `var'_m `var'_f
			qui: su `var' [aw `exp'] `if' `in' , meanonly 
			scalar ``var'_m' = (100^`pct')*r(mean)
			if "`stat_list'"=="" {
								local lamf `"``var'_m'"'
									}
								else {
									local lamf `", ``var'_m'"'
								}
								
			local stat_list   "`stat_list' `lamf'   "
 			local name_list   "`name_list' `var'_m"  
			if "`flag'" !=""  {
			 	repest_flags `var' `if' `in' [`weight' `exp'] 
				if "`flag_list'"=="" {
								local lamf `" `r(flag)'"'
									}
								else {
									local lamf `",  `r(flag)'"'
								}
								
				local flag_list   "`flag_list' `lamf'   "
				}	
		

			}
		}
		
	// store stats
	tempname b flags
 	matrix  `b' = [`stat_list']
	matrix colnames  `b' = `name_list'
	if "`flag'" !="" {
 		matrix `flags'=[`flag_list']
		}
	repest_replace_omit_res `b'
	matrix  `b' = r(beta)
	matrix colnames  `b' = `r(betanames)'
	ereturn post `b' 
	if "`flag'" !="" ereturn matrix flags=`flags'

end

* **** *
* FREQ *
* **** *

cap program drop repest_freq
program define repest_freq,eclass
	syntax varname [if] [in] [pweight aweight]  , levels(string) [flag]
	
	tempname total cell tab uniqlevels
	
	if "`levels'" == "" qui levelsof `varlist', local(levels)

	qui tab `varlist' [aw `exp'] `if' `in', matcell(`tab') matrow(`uniqlevels')
	foreach level in `levels' {
		local lev = regexr("`level'","-","m")
		tempname `varlist'_`lev'
		if "`stat_list'"=="" {
								local lamf `" ``varlist'_`lev''"'
									}
								else {
									local lamf `", ``varlist'_`lev''"'
								}
		local stat_list   "`stat_list' `lamf' "
		local name_list  "`name_list' `varlist'_`lev' "
 
		scalar ``varlist'_`lev'' = .
		if r(N) != 0 {
			matrix `total' =  (`tab'' * J(r(r),1,1))
			matrix `cell' = `tab' / `total'[1,1]
			matrix `cell' = 100*`cell'
			local max = rowsof(`uniqlevels')
			forval c = 1/`max' {
				if `level' == `uniqlevels'[`c',1] scalar ``varlist'_`lev'' = `cell'[`c',1]
				}
			if ``varlist'_`lev'' == . scalar ``varlist'_`lev'' = 0
			}
		}
		
		if "`flag'" !=""  {
			foreach level in `levels' { 
				repest_flags  if `varlist'==`level'
				if "`flag_list'"=="" {
								local lamf `" `r(flag)'"'
									}
								else {
									local lamf `", `r(flag)'"'
								}
				local flag_list   "`flag_list' `lamf'  "
 				}
			}	
		

	// store stats
	tempname b flags
 	matrix  `b' = [`stat_list']
	matrix colnames  `b' = `name_list'
	repest_replace_omit_res `b'
	if "`flag'" !="" {
 		matrix `flags'=[`flag_list']
		}
	matrix  `b' = r(beta)
	matrix colnames  `b' = `r(betanames)'
	ereturn post `b' 
  	if "`flag'" !="" ereturn matrix flags=`flags'

end


* ********* *
* SUMMARIZE *
* ********* *

cap program drop repest_summarize
program define repest_summarize,eclass
	syntax varlist [if] [in] [aweight pweight] , stats(string) [flag ]
	// check syntax
 	foreach stat in `stats' {
		if regexm("mean sd min max sum_w p1 p5 p10 p25 p50 p75 p90 p95 p99 skewness kurtosis sum N Var","`stat'") != 1 {
			di as error `"estimate suboption stats must contain elements computed in stata's summarize command"'
			error 198
			}
		}
	// summarize options	
	if "`stats'" == "mean" local sumoptions = ", meanonly"
	else if (regexm("`stats'","p") == 1 | regexm("`stats'","k") == 1)  local sumoptions = ", detail"
	// compute stats
	foreach outcome in `varlist' {
		qui: su `outcome' [aw `exp'] `if' `in' `sumoptions'
		foreach stat in `stats' {
			tempname `outcome'_`stat'  
			if "`stat_list'"=="" {
								local lamf `" ``outcome'_`stat''"'
									}
								else {
									local lamf `", ``outcome'_`stat''"'
								}
			local stat_list   "`stat_list' `lamf'   "
			local name_list   "`name_list' `outcome'_`stat'  "
			
 

			if `r(N)' == 0 scalar ``outcome'_`stat'' = .
			else if "`stat'" == "sd" & `r(N)' != 0 scalar ``outcome'_`stat'' = `r(sd)'*sqrt((`r(N)'-1)/`r(N)')
			else if "`stat'" == "Var" & `r(N)' != 0 scalar ``outcome'_`stat'' = `r(Var)'*(`r(N)'-1)/`r(N)'
			else scalar ``outcome'_`stat'' = r(`stat')
			}
			

		if "`flag'" !=""  {
			repest_flags `outcome'  `if' `in'
 			foreach stat in `stats' {
				if "`flag_list'"=="" {
								local lamf `" `r(flag)'"'
									}
								else {
									local lamf `", `r(flag)'"'
								}
				local flag_list  "`flag_list' `lamf'    "

				}
			}
		}
		
	// store stats 
	tempname b flags
	matrix  `b' = [`stat_list']
	if "`flag'" !=""   	matrix `flags'=[`flag_list'] 
 	matrix colnames  `b' = `name_list'
	repest_replace_omit_res `b'
	matrix  `b' = r(beta)
	matrix colnames  `b' = `r(betanames)'
	ereturn post `b' 
  	if "`flag'" !="" ereturn matrix flags=`flags'
 
end


* ************** *
* QUANTILE TABLE *
* ************** *

cap program drop repest_quantiletable
program define repest_quantiletable,eclass
	syntax varlist(numeric min=2 max=2) [if/] [in] [pweight aweight] [, flag NQuantiles(integer 4) noINDEXQuantiles noOUTCOMEQuantiles RELRisk ODDSratio SUmmarize(varname) REGress(varlist numeric min=2 max=2) test ]

	if "`if'" != "" local if "& `if'"
	tokenize `varlist'
	local index "`1'"
	local outcome "`2'"

	// initialise names
	tempname rrisk oratio `outcome'_qd beta r2 `summarize'_mean `summarize'_sd

	forval i = 1/`nquantiles' {
		tempname `index'_q`i' `outcome'_q`i'
		if "`indexquantiles'" == "" local index_quantiles = "`index_quantiles'" + "`index'_q`i' "
		if "`outcomequantiles'" == "" local outcome_quantiles = "`outcome_quantiles'" + "`outcome'_q`i' "
		}
	if "`test'" != "" {
		if "`outcomequantiles'" == "" local test "`outcome'_qd"
		else di as error "option test is ignored if option nooutcomequantiles is used"
		}
		
	if "`relrisk'" != "" 	local otherstats "rrisk"
	if "`oddsratio'" != "" 	local otherstats "`otherstats' oratio"
	if "`summarize'" != "" {
		local mean "`summarize'_mean"
		local sd "`summarize'_sd"
		}
	if "`regress'" != "" {
		local coeff "beta"
		local rsq   "r2"
		}

		

	// compute percentile thresholds 
	_pctile `index' [`weight' `exp'] if _n>0 `if' &  missing(`index') == 0 `in' , nq(`nquantiles')
	// compute requested quantile stats
	if r(r1) != . {
		if "`oddsratio'" != "" | "`relrisk'" != "" {
			tempvar `index'_q 
			qui gen ``index'_q' = (`index' <= r(r1)) if  missing(`index') == 0
			}
		local last = `nquantiles' - 1
		forval thr = 1/`last' {
			local k`thr' = r(r`thr')
			}

		// means by quantile
		forval q = 1/`nquantiles' {
			local qq = `q' - 1
			if "`indexquantiles'" == "" { 
				qui {
					if `q' == 1 su `index' [aw `exp'] if _n>0 `if' & `index' <= `k`q'' &  missing(`index') == 0 `in', meanonly
					else if `q' == `nquantiles' su `index' [aw `exp'] if _n>0 `if' & `index' > `k`qq'' &  missing(`index') == 0`in', meanonly
					else su `index' [aw `exp'] if _n>0 `if' & `index' > `k`qq'' & `index' <= `k`q''`in' &  missing(`index') == 0, meanonly
					
					scalar ``index'_q`q'' = r(mean)
					}
				}
			if "`outcomequantiles'" == "" { 
				qui {
					if `q' == 1 su `outcome' [aw `exp'] if _n>0 `if' & `index' <= `k`q'' &  missing(`index') == 0 `in', meanonly
					else if `q' == `nquantiles' su `outcome' [aw `exp'] if _n>0 `if' & `index' > `k`qq''  &  missing(`index') == 0 `in', meanonly
					else su `outcome' [aw `exp'] if _n>0 `if' & `index' > `k`qq'' & `index' <= `k`q''`in' &  missing(`index') == 0, meanonly
					

					scalar ``outcome'_q`q'' = r(mean)
					}	
				}

			}
		// difference across quantiles
		if "`outcomequantiles'" == "" scalar ``outcome'_qd' = ``outcome'_q`nquantiles'' - ``outcome'_q1'
		// relative risk and odds ratio
		if "`oddsratio'" != "" | "`relrisk'" != "" {
			_pctile `outcome' [aw `exp'] if _n>0 `if' `in', nq(`nquantiles')
			local thr = r(r1)
			tempname tab quarters total q1q1 q1rest
			qui ta ``index'_q' [aw `exp'] if _n>0 `if' & `outcome' <= `thr' `in', matcell(`tab') matrow(`quarters')  
			matrix `total' =  (`tab'' * J(r(r),1,1))
			scalar `q1q1' = `tab'[2,1] / `total'[1,1]
			qui ta ``index'_q' [aw `exp'] if _n>0 `if' & `outcome' > `thr' `in', matcell(`tab') matrow(`quarters')  
			matrix `total' =  (`tab'' * J(r(r),1,1))
			scalar `q1rest' = `tab'[2,1] / `total'[1,1]
			scalar `oratio' = (`q1q1'/(1-`q1q1'))/(`q1rest'/(1-`q1rest'))
			scalar `rrisk'= (`q1q1')/(`q1rest')
			}


			/*
			if "`flag'" == "flag" & `pv' <=1 & regexm("`exp'","r") != 1 scalar `outcome'`index'odds_f = flag
			if "`flag'" == "flag" & `pv' <=1 & regexm("`exp'","r") != 1 scalar `outcome'`index'rrisk_f = flag
			*/
		
		/*
		if "`flag'" == "flag" & `pv' <=1 & regexm("`exp'","r") != 1 {
			pisaflags2 `index' [`weight' `exp'] if _n>0 `if' `in'
			foreach stat in mean sd q1 q2 q3 q4 {
				scalar `index'`stat'_f = flag
				}
			forval stat = 1/`nquantiles' {
				scalar `index'q`stat'_f = flag
				}
			}
			

		if "`flag'" == "flag" & `pv' <=1 & regexm("`exp'","r") != 1 {
			pisaflags2 `index' `outcome' [`weight' `exp'] if _n>0 `if' `in'
			foreach stat in diff{
				scalar `outcome'`index'`stat'_f = flag
				}
			forval stat = 1/`nquantiles' {
				scalar `outcome'`index'q`stat'_f = flag
				}
			}
		*/
	}

	else {
			foreach stat in  `colnames' {
				scalar  `stat' = .
				scalar  `stat'_f = 1
				}
			}
	// compute requested descriptives 
	if "`summarize'" != "" 	{
		qui su `summarize' [aw `exp'] if _n>0 `if' `in'
		scalar ``summarize'_mean' = `r(mean)'
		scalar ``summarize'_sd' = `r(sd)'*sqrt((`r(N)'-1)/`r(N)')
		}
	// compute requested regression 
	if "`regress'" != "" 	{
		tokenize `regress'
		local depvar "`1'"
		local indepvar "`2'"
		qui reg `regress' [aw `exp'] if _n>0 `if' `in'
		scalar `beta' = _b[`indepvar']
		scalar `r2' = 100*e(r2)
		}
		

	// store stats
	foreach stat in `mean' `index_quantiles' `sd' `outcome_quantiles' `coeff' `otherstats' `rsq' `test' {
		local stat_list "`stat_list' ``stat''  , "
		local name_list   "`name_list' `stat'  "
		}
	tempname b
	local stat_list=regexr("`stat_list'", "\,.$" ,"")
	matrix  `b' = [`stat_list']
	matrix colnames  `b' = `name_list'
	repest_replace_omit_res `b'
	matrix  `b' = r(beta)
	matrix colnames  `b' = `r(betanames)'
	ereturn post `b' 

	if "`outcomequantiles'" != "" qui estadd scalar `outcome'_qd = ``outcome'_qd' 
	

end


* **** *
* CORR *
* **** *

cap program drop  repest_corr
program define  repest_corr, eclass
	syntax varlist(min = 2) [if] [in] [aweight pweight] [, pairwise flag]
	marksample touse
	tempname corr
	local ncol : word count `varlist'
	
	
	if "`pairwise'" == "" {
		cap corr `varlist' [aw `exp'] `if' `in'
		if _rc != 2000 	matrix `corr' = r(C)
		else matrix `corr' = .

		forval i = 1/`ncol' {
			local z = `i' + 1 
			forval j = `z'/`ncol' {
				if "`stat_list'" == "" local stat_list   "`corr'[`j',`i']"
				else local stat_list   "`stat_list' , `corr'[`j',`i']"
				local name_list   "`name_list' c_`=substr(word("`varlist'",`i'),1,12)'_`=substr(word("`varlist'",`j'),1,12)' "
				}
			}
		if "`flags"!="" {
			repest_flags if `touse' 
			forval i = 1/`ncol' {
				local z = `i' + 1 
				forval j = `z'/`ncol' {
					if "`flag_list'"=="" {
						local lamf `" `r(flag)'"'
						}
					else {
						local lamf `", `r(flag)'"'
						}
					local flag_list   "`flag_list' `lamf'   "
					}
				}
			}		
		}
	else {
		tokenize `varlist'
		forval i = 1/`ncol' {
			local z = `i' + 1 
			forval j = `z'/`ncol' {
				tempname corr_`i'_`j'
				cap corr ``i'' ``j'' [aw `exp'] `if' `in'
				if _rc != 2000 scalar `corr_`i'_`j'' = r(rho)
				else scalar `corr_`i'_`j'' = .
				if "`stat_list'"=="" {
								local lamf `"  `corr_`i'_`j''"'
									}
								else {
									local lamf `",  `corr_`i'_`j''"'
								}
				local stat_list   "`stat_list' `lamf'   "
				local name_list   "`name_list' pwc_`=substr(word("`varlist'",`i'),1,12)'_`=substr(word("`varlist'",`j'),1,12)' "
				}
			}
		if "`flags"!="" {
					forval i = 1/`ncol' {
						local z = `i' + 1 
						forval j = `z'/`ncol' {
							repest_flags if ``i''!=. &  ``j'' !=.
							if "`flag_list'"=="" {
								local lamf `" `r(flag)'"'
									}
								else {
									local lamf `", `r(flag)'"'
								}
							local flag_list   "`flag_list' `lamf'   "
							}
						}
				}			
		}
		
	// store stats
	tempname b  flags 
	if "`flags"!="" matrix  `flags' = [`flag_list']

	matrix  `b' = [`stat_list']
	matrix colnames  `b' = `name_list'
	repest_replace_omit_res `b'
	matrix  `b' = r(beta)
	matrix colnames  `b' = `r(betanames)'
	ereturn post `b' 
  	if "`flag'" !="" ereturn matrix flags=`flags'

end
