*---------------------------------------------------------*
*---------------------------------------------------------*
* JJ created 30 / 04 / 2015 ------------------------------*
* JJ updated 30 / 04 / 2015 ------------------------------*
*---------------------------------------------------------*

* This do-file provides the answers to section 7 of the computer workshop

*-----------------------------------*
*1. Keep only the data needed ------*
*-----------------------------------*
cd "C:\Users\john\OneDrive\Documents\Teaching\RCT_Course\"
use "DATA_FOR_ARCHIEVE.dta", clear

rename ks2_engreadmrk PRE_TEST_READING
rename ks2_mattotmrk PRE_TEST_MATH
rename fsmeligible_aut14 FSM
rename GROUP TREATMENT
rename PostTest_Outcome_1 Post_Test
drop rawscore - _merge
drop ks*
drop STRATA

encode gender_aut14, gen(GENDER)
drop gender_aut14

save "CW_BASIC_ANALYSIS_EX_2.dta" , replace

*---------------------------------------------------*
*QUESTION 1. Standardise the outcome variable ------*
*---------------------------------------------------*
use "CW_BASIC_ANALYSIS_EX_2.dta" , clear											/* Open up the data */

	*A. Create new variable
	gen Post_Test_Stand = .
	
	*B. Summary statistics for the post test
	sum Post_Test, d		/* Mean = 23.34 ; SD = 11.05 */
	
	*C. Standardise the post-score variable
	replace Post_Test_Stand = (Post_Test - 23.34) / 11.05
	
	*D. Summary stats for the standardised post-test score
	sum Post_Test_Stand , d
	
	*E. Correlation between standardised and unstandardised post-test scores
	corr Post_Test Post_Test_Stand

*---------------------------------------------------*
*QUESTION 2. Check balance -------------------------*
*---------------------------------------------------*
	*2A. Pre-test scores
	tab TREATMENT, sum(PRE_TEST_READING)											/* Provide mean pre-test reading score for T and C group */
	tab TREATMENT, sum(PRE_TEST_MATH)												/* Provide mean pre-test math score for T and C group */
	* Very similar in terms of prior achievement
	
	*2B. Gender
	tab GENDER TREATMENT , col														/* Cross-tabulate gender by treatment group */
	* slightly higher % boys in control than treatment group
	
	*2C. FSM eligibility
	tab FSM TREATMENT , col															/* Cross-tabulate FSM by treatment group */
	* Slightly higher % poor kids in T than C
	
*---------------------------------------------------*
*QUESTION 3. Treatment effect (comparison of means)-*
*---------------------------------------------------*	
	regress ///																		/* OLS regression.... */
		Post_Test_Stand  ///														/* Post-test scores (standardised) as dependent variable */
		TREATMENT ///																/* Treatment group dummy the only independent variable */
			, ///																	/* Following options..... */
			cluster(ID_SCHOOL)														/* Cluster by school ID (to get the correct standard error) */
	
*---------------------------------------------------*
*QUESTION 4. Treatment effect (regression model) ---*
*---------------------------------------------------*	
* You would prefer this estimate to the one provided by question 3.
* First, you are accounting for any chance imbalance in terms of observables....
* Second, you increase power by controlling for pre-test scores....
* (Note the reduction in the standard error)....

	regress ///																		/* OLS regression.... */
		Post_Test_Stand  ///														/* Post-test scores (standardised) as dependent variable */
		TREATMENT  GENDER FSM  PRE_TEST_READING  PRE_TEST_MATH ///					/* Now include covariates for FSM, GENDER and PRE-TEST */
			, ///																	/* Following options..... */
			cluster(ID_SCHOOL)														/* Cluster by school ID (to get the correct standard error) */

*---------------------------------------------------*
*QUESTION 5. FSM*Treatment interaction -------------*
*---------------------------------------------------*	
	*5A. Seperate estimates
		*5Ai. Non-FSM
		regress ///																	/* OLS regression.... */
			Post_Test_Stand  ///													/* Post-test scores (standardised) as dependent variable */
			TREATMENT  GENDER  PRE_TEST_READING  PRE_TEST_MATH ///					/* Now include covariates for FSM, GENDER and PRE-TEST */
				if FSM == 0	///														/* Non-FSM */
				, ///																/* Following options..... */
				cluster(ID_SCHOOL)													/* Cluster by school ID (to get the correct standard error) */

		*5Aii. FSM
		regress ///																	/* OLS regression.... */
			Post_Test_Stand  ///													/* Post-test scores (standardised) as dependent variable */
			TREATMENT  GENDER  PRE_TEST_READING  PRE_TEST_MATH ///					/* Now include covariates for FSM, GENDER and PRE-TEST */
				if FSM == 1	 ///													/* FSM */
				, ///																/* Following options..... */
				cluster(ID_SCHOOL)													/* Cluster by school ID (to get the correct standard error) */		
				
	*5B. Interaction in model
		*5Bi. Create TReatment by FSM interaction
		gen FSM_INTERACTION = TREATMENT*FSM											/* Interaction = multiply FSM and TREATMENT together */
		
		regress ///																	/* OLS regression.... */
			Post_Test_Stand  ///													/* Post-test scores (standardised) as dependent variable */
			TREATMENT  GENDER  PRE_TEST_READING  PRE_TEST_MATH FSM  ///				/* Now include covariates for FSM, GENDER and PRE-TEST */
				FSM_INTERACTION ///													/* INCLUDE THE INTERACTION IN THE MODEL */
				, ///																/* Following options..... */
				cluster(ID_SCHOOL)													/* Cluster by school ID (to get the correct standard error) */		
	
* NEITHER OF THE ABOVE SUGGESTS THERE IS ANY *
* INTERACTION OF THE TREATMENT EFFECT WITH FSM! *	
	
*---------------------------------------------------*
*QUESTION 6. Gender*Treatment interaction ----------*
*---------------------------------------------------*		
	*6A. Seperate estimates
		*6Ai. FEMALE
		regress ///																	/* OLS regression.... */
			Post_Test_Stand  ///													/* Post-test scores (standardised) as dependent variable */
			TREATMENT  FSM  PRE_TEST_READING  PRE_TEST_MATH ///						/* Now include covariates for FSM, GENDER and PRE-TEST */
				if GENDER == 1	///													/* FEMALE */
				, ///																/* Following options..... */
				cluster(ID_SCHOOL)													/* Cluster by school ID (to get the correct standard error) */

		*6Aii. MALE
		regress ///																	/* OLS regression.... */
			Post_Test_Stand  ///													/* Post-test scores (standardised) as dependent variable */
			TREATMENT  FSM  PRE_TEST_READING  PRE_TEST_MATH ///						/* Now include covariates for FSM, GENDER and PRE-TEST */
				if GENDER == 2	///													/* MALE */
				, ///																/* Following options..... */
				cluster(ID_SCHOOL)													/* Cluster by school ID (to get the correct standard error) */	
				
	*6B. Interaction in model
		*6Bi. Create TReatment by FSM interaction
		gen GENDER_INTERACTION = TREATMENT*GENDER									/* Interaction = multiply GENDER and TREATMENT together */
		
		regress ///																	/* OLS regression.... */
			Post_Test_Stand  ///													/* Post-test scores (standardised) as dependent variable */
			TREATMENT GENDER FSM  PRE_TEST_READING  PRE_TEST_MATH  ///				/* Now include covariates for FSM, GENDER and PRE-TEST */
				GENDER_INTERACTION ///												/* INCLUDE THE INTERACTION IN THE MODEL */
				, ///																/* Following options..... */
				cluster(ID_SCHOOL)													/* Cluster by school ID (to get the correct standard error) */		
	
* NEITHER OF THE ABOVE SUGGESTS THERE IS ANY INTERACTION * 
* OF THE TREATMENT EFFECT WITH GENDER! *	
	
	
	
	
	