*****************************************
** JJ Created 08 / 04 / 2015 ************
** JJ Updated 08 / 04 / 2015 ************
*****************************************

*-------------------------------------------------------------*
* This do-file performs the analysis for computer workshop 1
* "Basic Analysis of RCT data"
*-------------------------------------------------------------*

*------------------------------------------------------------------*
*1. Inital preparation of the data --------------------------------*
*------------------------------------------------------------------*
	*A. Open the data
	cd "C:\Users\john\Documents\Consultancy\TWIGG\Malaysia\"						/* Change directory to where data stored */
	use "Malaysia_Data_TEACHING.dta" , clear										/* Open up the final dataset */

	*B. Create the new gender variable
	gen Gender_ALT = .																/* Create new variable. Set to missing by default */
	replace Gender_ALT = 0 if Gender == 1											/* 0 = Female */
	replace Gender_ALT = 1 if Gender == 2 | Gender == 3 | Gender == 4				/* 1 = Male */

	drop Gender																		/* Drop the old gender variable */
	rename Gender_ALT Gender														/* Rename the newly created gender variable */

	label define Gender1 ///														/* Create new variable label */
		0 "Girl" ///
		1 "Boy"
	
	label values Gender Gender1														/* Assign label to variable */
	
	tab Gender																		/* Tab the gender variable */
	
	*C. Rename the ID variable
	rename NO ID
	rename Pre_Test_Total Pre_Test
	rename Post_Test_Total Post_Test	
		
	*D. Keep only variables student need
	keep ID Gender TREATMENT Pre_Test Post_Test										/* Keep only the variables will use */

	*E. Save the final teaching dataset
	save "CW1_TEACHING_DATASET.dta" , replace										/* Re-save the dataset */


*--------------------------------------------*
* Section 1. Descriptive statistics ---------*
*--------------------------------------------*
	*A. Open up the datset
	use "CW1_TEACHING_DATASET.dta" , clear												/* Open the dataset */

	*B. Summary stats for the post-test
	sum Post_Test , d

	*C. Correlation between the pre-test and the post-test
	correl Pre_Test Post_Test
	scatter Pre_Test Post_Test


*--------------------------------------------*
* Section 2. Comparison of mean scores ------*
*--------------------------------------------*
	*A. Simple difference in means
	regress Post_Test TREATMENT

*--------------------------------------------*
* Section 3. Checking balance ---------------*
*--------------------------------------------*	
	*A. Mean pre-test scores
	mean Pre_Test if TREATMENT == 0
	mean Pre_Test if TREATMENT == 1

	*b. Mean pre-test scores
	proportion Gender if TREATMENT == 0
	proportion Gender if TREATMENT == 1

*--------------------------------------------*
* Section 4. Using regression models --------*
*--------------------------------------------*
	*A. Run model
	regress Post_Test Pre_Test Gender TREATMENT

*--------------------------------------------*
* Section 5. Effect sizes -------------------*
*--------------------------------------------*	
	*A. Create new variable
	gen Post_Test_Stand = .
	
	*B. Summary statistics for the post test
	sum Post_Test, d		/* Mean = 12.40 ; SD = 5.58 */
	
	*C. Standardise the post-score variable
	replace Post_Test_Stand = (Post_Test - 12.40) / 5.58
	
	*D. Summary stats for the standardised post-test score
	sum Post_Test_Stand , d
	
	*E. Correlation between standardised and unstandardised post-test scores
	corr Post_Test Post_Test_Stand

	*F. Estimated treatment effect (in terms of effect size)
	regress Post_Test_Stand Pre_Test Gender TREATMENT

	*G. New variable for Glass's delta
	gen Glass_Dleta = .
	
	*H. Get the control group SD
	sum Post_Test if TREATMENT == 0, d		/* SD = 5.11 */
	
	*I. Create Glass delta: pooled mean (12.40) and control group SD (5.11)
	replace Glass_Dleta  = (Post_Test - 12.40) / 5.11

	*F. Estimated treatment effect (in terms of GLASS'S DELTA)
	regress Glass_Dleta Pre_Test Gender TREATMENT

*--------------------------------------------*
* Section 6. Heterogeneous treatment effects *
*--------------------------------------------*		
	*A. Treatment effect for girls
	regress Post_Test_Stand Pre_Test TREATMENT if Gender == 0

	*B. Treatment effect for boys
	regress Post_Test_Stand Pre_Test TREATMENT if Gender == 1	
	
	*C. Create interaction
	gen INTERACTION = Gender*TREATMENT 
	
	*D. Interaction model
	regress Post_Test_Stand Pre_Test TREATMENT Gender INTERACTION
	
