*----------------------------------------------------------------*
* JJ created 24/04/2017 -----------------------------------------*
* JJ updated 24/04/2017 -----------------------------------------*
*----------------------------------------------------------------*

* This do-file illustrates the use of forvalues loops

*---------------------------------------------------------------*
* 1. Illustration of the forvalues loop ------------------------*	
*---------------------------------------------------------------*				
	cd "C:\Users\john\OneDrive\Documents\Teaching\Stata_Course\Lecture_3\Lecture_3_Data\"
	use "Lecture_3_Data_1.dta" , clear
	
	*1A. Doing things the hard way. Estimating the mean for 10 seperate variables.
	mean PV1MATH
	mean PV2MATH
	mean PV3MATH
	mean PV4MATH
	mean PV5MATH
		
	*1B. Using the forvalues loop
	forvalues pv = 1(1)5 {															/* Looping over the ten values */
		mean PV`pv'MATH																/* Calculate the mean for each of the ten test scores */
		}																			/* CLOSE THE FORVALUES LOOP */ 
	
	
	******** TASK 1. STANDARDISE EACH OF THE FIVE MATHS TEST SCORES ***********
		
		
		
		
		
		
		
		
		
		
		
		
*---------------------------------------------------------------*
* 2. Illustration of the foreach loop --------------------------*	
*---------------------------------------------------------------*						
	*2A. Open up the data
	use "Lecture_3_Data_1.dta" , clear
				
	*2B. Define a local macro
	local my_countries  ///
		AUT /// 
		DEU ///
		GBR ///
		JPN ///
		USA
				
	*2C. Illustration of a foreach loop.
	*Calculate mean for each country for PV1MATH
	foreach cnt of local my_countries {												/* Start the loop.... */
		mean PV1MATH ///															/* Mean for the first maths score */
			if ///	
			CNT == "`cnt'" 															/* If the variable CNT is equal to the value in the local macro */ 												
	}																				/* CLOSE THE LOOP */ 
		
	*2D. TASK 2. Run a regression model in each country, with PV1MATH as the
	*			 dependent variable, and the ESCS index as the independent 
	*			 variable. For each country, save the estimated regression 
	*			 coefficient as a new variable.
	*			 You should do this for each country (variable= CNT) in the datafile.
		
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
*---------------------------------------------------------------*
* 3. Looping within a loop -------------------------------------*	
*---------------------------------------------------------------*	
* The following calculates five mean maths score per country, using a double loop.	

* NOTE: THE "INNER" LOOP IS THE FORVALUES LOOP. 
*	    THE "OUTER" LOOP IS THE FOREACH.
*		The

* E.g. It will start by doing the analysis for Austria (AUT) as this is the first
*	   element in the "outer" loop
*	   For Austria, it will work out the five maths scores 
*	   (i.e. it will cycle through the entire contents of the inner loop)
*	   before moving on to the next element of the outer loop (DEU).
	
	
	*3A. Open up the data
	use "Lecture_3_Data_1.dta" , clear
				
	*3B. Define a local macro
	local my_countries  ///
		AUT /// 
		DEU ///
		GBR ///
		JPN ///
		USA	
	
	*3C. Calculate five mean maths scores per country
	foreach cnt of local my_countries {												/* OPEN the FOREACH loop */ 
		*i. Display oountry name
		display "`cnt'"																/* Put country name at the top */
		
		*ii. Get the mean score for each of the five test scores
		forvalues pv = 1(1)5 {														/* OPEN the FORVALUES loop */ 
			mean PV`pv'MATH ///														/* Calculate the average maths score.... */
				if CNT == "`cnt'"													/* ....one country at a time */ 
		}																			/* CLOSE the FORVALUES loop */
	}																				/* CLOSE the FOREACH loop */ 
		
*---------------------------------------------------------------*
* 4. Task 3 ----------------------------------------------------*	
*---------------------------------------------------------------*		
* The dataset contains a set of 80 weights. These are labelled W_FSTR1 to W_FSTR80.
* You can apply these weights to Stata functions. For instance, try
mean PV1MATH [pw = W_FSTR1]


* TASK 3A
*For Austria, please calculate 80 versions of the mean score for Austria for each
* of the 5 mathematics test scores (PV1MATH), applying a different weight each time.
	
*HINT! Below is the starting segment of code doing this the long way round
*	  (i.e. without using loops)
/*
mean PV1MATH [pw = W_FSTR1] if CNT == "AUT"
mean PV1MATH [pw = W_FSTR2] if CNT == "AUT"
mean PV1MATH [pw = W_FSTR3] if CNT == "AUT"
mean PV1MATH [pw = W_FSTR4] if CNT == "AUT"
mean PV1MATH [pw = W_FSTR5] if CNT == "AUT"
mean PV1MATH [pw = W_FSTR6] if CNT == "AUT"
*/	


		
*TASK 3B. Instead of doing the above for Austria only, please now do the above
*		  for all countries in the dataset.	

	
		
		
				