*-------------------------------------------------------*
* JJ created 24 / 04 / 2017 ----------------------------*
* JJ updated 24 / 04 / 2017 ----------------------------*
*-------------------------------------------------------*

* This is an example of where there is an important difference between an
* evaluated macro (has an = sign) and an unevaluated macro (no = sign)

* See Baum (2005) notes pages 5 and 6

*-----------------------------------------------------------*
*1. Unevaluated local macro --------------------------------*
*-----------------------------------------------------------*
	*1A. Create a local macro with the value of 0
	local count 0
	
	*1B. Creates a local macro with country abbreviations inside
	local country ///
		US ///
		UK ///
		DE ///
		FR
	
	*1C. Uses a foreach loop to display a country list
	foreach c of local country {													/* Looping over the things in the list defined in 1B */
		local count ///																/* Re-define the local macro .... */
			`count'+1					/* WITHOUT = SIGN */ 						/* ...so it reports its "current contents + 1" */ 
		
		display ///																	/* Display the following in a string */
			"Country `count' : `c'"													/* `count' returns current contents of `count'. `c' the contents of the local country in this iteration of the loop */ 
	}																				/* CLOSE THE FOREACH LOOP */
	
*Lines 26/27 reads this as saying "re-define the local macro country with its 
* "current value + 1" as if this were a string. 
* Hence it reads it as 0+1, then 0+1+1, then 0+1+1+1

*-----------------------------------------------------------*
*2. Evaluated local macro --------------------------------*
*-----------------------------------------------------------*	
	*2A. Create a local macro with the value of 0
	local count 0
	
	*2B. Creates a local macro with country abbreviations inside
	local country ///
		US ///
		UK ///
		DE ///
		FR
	
	*2C. Uses a foreach loop to display a country list
	foreach c of local country {													/* Looping over the things in the list defined in 1B */
		local count ///																/* Re-define the local macro .... */
			 = ///					/* WITH = SIGN */
			`count'+1					 											/* ...so it reports its current contents + 1 */ 
					
		display ///																	/* Display the following in a string */
			"Country `count' : `c'"													/* `count' returns current contents of `count'. `c' the contents of the local country in this iteration of the loop */ 
	}			

*Lines 53/54/55 reads this as saying "re-define the local macro country with its 
* current value + 1, and it EVALUATES THIS. 
* Hence it reads it as 0+1 =1 - and so reports the value 1
* Then it reads 1+1, so reports the value 2.
* Then it reads 2+1, so reports the value 3 etc. 	
	
*--------------------------------------------------------------*
* 3. Using Stata's automatic incrementer ----------------------*
*---------------------------------------------------------------
*This does the same as the above with the ++<macro name> shortcut.
*What this does essentially move the local macro (my_count) by one within
*each iteration of the loop.

	*3A. Define a new local macro, to contain the value of zero.
	local my_count 0
	
	*3B. Go through the loop
	foreach c of local country {													/* Looping over the things in the list defined in 1B */
		
		*i. Move the my_count local macro on by one
		local ++my_count
		
		*ii. Display the following string
		display ///																	/* Display the following in a string */
			"Country `my_count' : `c'"												/* `count' returns current contents of `count'. `c' the contents of the local country in this iteration of the loop */ 
	}																				/* CLOSES the FOREACH loop */ 		
	
		
	
	
	
	
	